package com.baijia.tianxiao.dal.signup.dao.impl;

import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.base.Preconditions;

import lombok.extern.slf4j.Slf4j;

import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/6/30
 * Time: 下午6:25
 * To change this template use File | Settings | File Templates.
 */
@Slf4j
@Repository
public class OrgSignupRefundDaoImpl extends JdbcTemplateDaoSupport<OrgSignupRefund> implements OrgSignupRefundDao {

    OrgSignupRefundDaoImpl() {
        super(OrgSignupRefund.class);
    }

    @Override
    public List<OrgSignupRefund> getOrgSignupRefundListByMinId(Long minId, Date lastDate, int maxSize, String... queryProps) {
        Preconditions.checkArgument(maxSize > 0, "maxSize is illegal");
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder(queryProps);
        if (minId == null || minId == 0) {
            if (lastDate == null) {
                throw new IllegalArgumentException("must have minId or lastDate");
            }
            builder.gt("createTime", lastDate);
            builder.asc("createTime");
        } else {
            builder.gt("id", minId);
            builder.asc("id");
        }
        builder.setMaxSize(maxSize);
        return queryList(builder);
    }

    @Override
    public List<OrgSignupRefund> getOrgSignupRefundListByPurchaseId(Long orgId, Long purchaseId,Long courseId) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.eq("org_id", orgId);
        builder.eq("signup_purchase_id", purchaseId);
        builder.eq("course_id", courseId);
        return queryList(builder);
    }

	@Override
	public int getRefundTime(Long orgId, Long signupPurchaseId, Long courseId) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.count("id");
        builder.eq("org_id", orgId);
        builder.eq("signup_purchase_id", signupPurchaseId);
        builder.eq("course_id", courseId);
        return queryForObject(builder, Integer.class);
	}

    @Override
    public List<OrgSignupRefund> getByPurcahseIds(Set<Long> purchaseIds) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.in("signup_purchase_id", purchaseIds);
        return queryList(builder);
    }
}
