
package com.baijia.tianxiao.dal.signup.dao.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.BatchQueryTemplate;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.google.common.collect.Maps;

import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
@Slf4j
@Repository
public class OrgSignupCourseDaoImpl extends JdbcTemplateDaoSupport<OrgSignupCourse> implements OrgSignupCourseDao {

    public OrgSignupCourseDaoImpl() {
        super(OrgSignupCourse.class);
    }

    @Override
    public List<Long> searchPurchaseIdByCourseId(@NonNull Collection<Long> courseIds, Date startTime, Date endTime) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyList();
        }
        SingleSqlBuilder<OrgSignupCourse> builder = createSqlBuilder();
        builder.select("signupPurchaseId");
        builder.in("orgCourseId", courseIds);
        if (startTime != null) {
            builder.ge("createTime", startTime);
        }
        if (endTime != null) {
            builder.le("createTime", endTime);
        }

        return queryForList(builder, Long.class);
    }

    @Override
    public List<OrgSignupCourse> loadByPurchaseIds(@NonNull Collection<Long> purchaseIds, final String...queryProps) {
        if (CollectionUtils.isEmpty(purchaseIds)) {
            return Collections.emptyList();
        }
        BatchQueryTemplate<Long, List<OrgSignupCourse>> queryTemplate = new ListBatchQueryTemplate<>();
        return queryTemplate.batchQuery(purchaseIds, new BatchQueryCallback<Long, List<OrgSignupCourse>>() {
            @Override
            public List<OrgSignupCourse> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder<OrgSignupCourse> builder = createSqlBuilder();
                builder.select(queryProps);
                builder.in("signupPurchaseId", querySet);
                return queryList(builder);
            }
        });
    }

    @Override
    public List<OrgSignupCourse> loadByPurchaseId(@NonNull Long purchaseId, String...queryProps) {
        SingleSqlBuilder<OrgSignupCourse> builder = createSqlBuilder();
        builder.select(queryProps);
        builder.eq("signupPurchaseId", purchaseId);
        return queryList(builder);

    }

    @Override
    public void saveOrUpdateSignupCourse(@NonNull OrgSignupCourse signupCourse) {
        if (signupCourse.getId() > 0) {
            update(signupCourse);
        } else {
            save(signupCourse);
        }
    }

    public void updateByCourseId(@NonNull OrgSignupCourse signupCourse) {
        Map<String, Object> updateCondition = Maps.newHashMap();
        updateCondition.put("orgCourseId", signupCourse.getOrgCourseId());
        update(updateCondition, signupCourse);
    }

    @Override
    public void saveSignupCourses(List<OrgSignupCourse> courses) {
        saveAll(courses);
    }

	@Override
	public OrgSignupCourse getByCourseId(Long orgId,Long purchaseId, Long courseId) {
        SingleSqlBuilder<OrgSignupCourse> builder = createSqlBuilder();
        builder.eq("org_id", orgId);
        builder.eq("org_course_id",courseId);
        builder.eq("signup_purchase_id", purchaseId);
		return uniqueResult(builder);
	}

}
