package com.baijia.tianxiao.dal.signup.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import lombok.NonNull;

public interface OrgSignupInfoDao extends CommonDao<OrgSignupInfo> {

    /**
     * 获取报名人数
     *
     * @param orgId
     * @return
     */
    int countByOrgId(Long orgId);

    /**
     * monthDiff=0 本月 monthDiff=1 上月
     *
     * @param orgId
     * @param monthDiff
     * @return
     */
    int countByOrgId(Long orgId, int monthDiff);

    int countByTime(Long orgId, Date startTime, Date endTime);

    /***
     * 根据报名状态查询个数
     *
     * @param purchaseStatus
     * @return
     */
    int countByPurchaseStatus(@NonNull Long orgId, @NonNull Collection<Integer> purchaseStatus,
                              @NonNull Collection<Integer> splitResults, Integer cascadeId);

    /**
     * 根据报名状态查询订单金额
     *
     * @param purchaseStatus
     * @return
     */
    Long sumByPurchaseStatus(@NonNull Long orgId, @NonNull Collection<Integer> purchaseStatus,
                             @NonNull Collection<Integer> splitResults, Integer cascadeId, boolean notCash);

    /**
     * 根据学生姓名和学生手机查询机构的订单ID,如果KEY为空,返回列表为空
     *
     * @param orgId
     * @param key   必须不为空
     * @return
     */
    List<Long> searchPurchaseIdByStudentInfo(Long orgId, String key, Date startTime, Date endTime);

    /**
     * 根据订单ID查询注册订单信息
     *
     * @param purchaseIds
     * @return
     */
    List<OrgSignupInfo> searchByPurchaseIds(Collection<Long> purchaseIds, String... queryProps);

    /**
     * 根据订单ID查询报名信息
     *
     * @param purchaseId
     * @return
     */
    OrgSignupInfo searchByPurchaseId(Long purchaseId, String... queryProps);

    /**
     * 如果ID为空,自动保存
     *
     * @param signupInfo
     */
    void saveOrUpdateSignupInfo(OrgSignupInfo signupInfo);

    /**
     * @param purchaseId
     * @param isLock
     * @param queryProps
     * @return
     */
    OrgSignupInfo searchByPurchaseId(Long purchaseId, boolean isLock, String... queryProps);

    List<OrgSignupInfo> getOrgSignupInfo(List<Integer> method, List<Integer> source, Long orgId,
                                         Collection<Long> purchaseIds, Collection<Integer> purchaseStatus, Collection<Integer> splitResults,
                                         Collection<Integer> payTypes, String key, Date startTime, Date endTime, Integer cascadeId, PageDto page,
                                         String... queryPropes);

    /**
     * 查询历史订单
     *
     * @param purchaseStatus
     * @param createTime
     * @return
     */
    List<OrgSignupInfo> searchHistoryPurchases(Integer purchaseStatus, Date createTime, Integer maxSize);

    /**
     * 获取机构学生报名订单
     *
     * @param userId
     * @param
     * @param payType
     * @param purchaseStutus
     * @return
     */
    List<OrgSignupInfo> getPurchases(Long userId, Long orgNumber, Integer payType, Integer purchaseStutus,
                                     String... queryProps);

    /**
     * 获取机构学生报名订单
     *
     * @param
     * @param
     * @param
     * @param purchaseStutus
     * @return
     */
    List<OrgSignupInfo> getPurchases(Date updateTime, Integer purchaseStutus, PageDto page, String... queryProps);

    /**
     * 查询最近的报名信息
     *
     * @param minId
     * @param lastDate
     * @param maxSize
     * @param queryProps
     * @return
     */
    List<OrgSignupInfo> getOrgSignupListByMinId(Long minId, Date lastDate, int maxSize, String... queryProps);

    /**
     * 根据更新时间查询最近报名信息
     */
    List<OrgSignupInfo> getOrgSignupListByUpdate(Long minId, Date lastDate, int maxSize, String... queryProps);

    /**
     * 查询学员报名信息
     */
    OrgSignupInfo getOrgSignupInfoByUserId(Long orgId, Long userId);

    /**
     * 用于总校区
     *
     * @param orgId
     * @param startTime
     * @param endTime
     * @return
     */
    int countByTime(List<Long> orgId, Date startTime, Date endTime);

    List<OrgSignupInfo> getPurchases(Date startTime, Date endTime, List<Long> orgIds, PageDto page);

    OrgSignupInfo getByPurchaseId(Long orgId, Long signupPurchaseId);

    // List<OrgSignupInfo> getList(Integer orgId, SignupSearchRequest signupSearchRequest);

    /**
     * 分校区
     *
     * @param orgIds
     * @param startTime
     * @param endTime
     * @return
     */
    Map<Integer, Integer> countSubOrgByTime(List<Integer> orgIds, Date startTime, Date endTime);

    List<OrgSignupInfo> listByStatus(Long orgId, Collection<Integer> purchaseStatus, Collection<Integer> splitResults,
                                     Integer cascadeId, boolean noCash, PageDto page, String... queryPropes);

    /**
     * 查找支付成功,未把订单课程信息同步到主站的接口
     *
     * @param splitResult
     * @param payResult
     * @param payType
     * @param signupType
     * @param queryPropes
     * @return
     */
    List<OrgSignupInfo> searchSignupInfoWithCourseInfo(List<Integer> splitResult, List<Integer> payResult,
                                                       List<Integer> payType, Integer signupType, String... queryPropes);


    List<OrgSignupInfo> searchByPurchaseIdsWithCourseInfo(Collection<Long> purchaseIds, String... queryProps);

    List<Long> getSignupFailPurchaseId();

    /**
     * 报名成功没有同步的数据,发短信,同步1v1班级
     *
     * @return
     */
    List<OrgSignupInfo> getSignupSuccessAndNotSync();

    /**
     * 获取某个机构某天的报名金额
     *
     * @param orgId
     * @param mdate
     * @return
     */
    Long getSignupPriceByDay(Long orgId, String mdate,Integer opType);

    Integer countSignupPriceByDay(Long orgId, String mdate,Integer opType);


    void updateSignupSmsStatus(Long id,Date updateTime);

    void updateSignupFinanceStatus(Long id,Date updateTime);

}
