package com.baijia.tianxiao.dal.show.po;

import com.baijia.tianxiao.sqlbuilder.annotation.*;
import lombok.Data;

import java.util.Date;

/**
 * 字段显示属性
 * Created by wangsixia on 2016/11/9.
 */
@Data
@Entity
@Table(name = "tx_field_show_info", catalog = "yunying")
public class FieldShowInfo {
    @Id
    @GeneratedValue
    private Long id;

    // 机构id
    @Column(name = "org_id")
    private Long orgId;

    // 属性类型 DataProcType
    @Column(name = "type")
    private int type;

    // 是否系统字段
    @Column(name = "is_sys")
    private int isSys;

    // 显示字段列表中的前一个属性的fieldShowInfo.id,第一个字段的preShowId为null,只有showStatus=0的才进行排序
    @Column(name = "pre_show_id")
    private Long preShowId;

    // 自定义字段id  CustomField.id,系统字段则为null
    @Column(name = "custom_field_id")
    private Long customFieldId;

    // 字段属性名,用于列表展示的属性名:系统字段如"mobile";由于CustomField表中自定义字段的name为对应的id值,这里统一用"custom_"+custom.id存储,如"custom_1000",表示自定义字段属性名
    @Column(name = "name")
    private String name;

    // 字段显示名,系统字段如"手机号";自定义字段如:"单选"、"多选",与name中的"custom_1000"对应
    @Column(name = "show_name")
    private String showName;

    // 排序字段名
    @Column(name = "query_prop")
    private String queryProp;

    // 是否锁定:0不锁定;1锁定,mysql关键字有lock
    @Column(name = "locked")
    private int locked;

    // 是否排序:0不排序;1排序
    @Column(name = "sorted")
    private int sorted;

    // 字段显示状态 ShowStatus: 0显示字段;1隐藏字段;2隐藏属性
    @Column(name = "show_status")
    private int showStatus;

    // FieldStatus:0正常,1停用,2删除。若isSys=1为系统字段,则不可删除/停用
    @Column(name = "field_status")
    private int fieldStatus;

    // 创建时间
    @Column(name = "create_time")
    private Date createTime;

    // 更新时间
    @Column(name = "update_time")
    private Date updateTime;
}
