package com.baijia.tianxiao.dal.show.dao.impl;

import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.show.dao.FieldShowInfoDao;
import com.baijia.tianxiao.dal.show.enums.FieldStatus;
import com.baijia.tianxiao.dal.show.enums.ShowStatus;
import com.baijia.tianxiao.dal.show.po.FieldShowInfo;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * Created by wangsixia on 2016/11/10.
 */
@Repository
public class FieldShowInfoDaoImpl extends JdbcTemplateDaoSupport<FieldShowInfo> implements FieldShowInfoDao{

    @Override
    public List<FieldShowInfo> getOrgFieldShow (Long orgId, int type, int fieldStatus, Collection<Integer> showStatusColl) {
        SingleSqlBuilder<FieldShowInfo> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("type", type);
        builder.eq("fieldStatus", fieldStatus);
        if (CollectionUtils.isNotEmpty(showStatusColl)) {
            builder.in("showStatus", showStatusColl);
        }
        return queryList(builder);
    }

    @Override
    public boolean hasInit(Long orgId, int type) {
        SingleSqlBuilder<FieldShowInfo> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("type", type);
        builder.count("id");
        Integer count = queryForObject(builder, Integer.class);
        if (count != null && count > 0) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public boolean consistencyCheck(Long orgId, int type, Date lastGetTime) {
        SingleSqlBuilder<FieldShowInfo> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("type", type);
        builder.ne("fieldStatus", FieldStatus.DELETED.getCode());
        builder.max("updateTime", "lastUpdateTime");
        Date lastUpdateTime = queryForObject(builder, Date.class);
        if (lastUpdateTime != null && lastUpdateTime.before(lastGetTime)) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public Long getLastLockInfo(Long orgId, int type) {
        SingleSqlBuilder<FieldShowInfo> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("type", type);
        builder.eq("isSys", BizConf.TRUE.intValue());
        builder.eq("locked", BizConf.TRUE.intValue());
        builder.eq("fieldStatus", FieldStatus.NORMAL.getCode());
        builder.eq("showStatus", ShowStatus.SHOW.getCode());
        builder.max("id");
        return queryForObject(builder, Long.class);
    }

    @Override
    public FieldShowInfo getShowBehind(Long orgId, int type, Long preId, String...queryProps) {
        SingleSqlBuilder<FieldShowInfo> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        builder.eq("type", type);
        builder.eq("fieldStatus", FieldStatus.NORMAL.getCode());
        builder.eq("showStatus", ShowStatus.SHOW.getCode());
        builder.eq("preShowId", preId);
        return uniqueResult(builder);
    }

    @Override
    public FieldShowInfo getByCustomId(Long orgId, int type, Long customFieldId, String...queryProps) {
        SingleSqlBuilder<FieldShowInfo> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        builder.eq("type", type);
        builder.eq("isSys", BizConf.FALSE.intValue());
        builder.eq("customFieldId", customFieldId);
        return uniqueResult(builder);
    }
}
