package com.baijia.tianxiao.dal.show.dao;

import com.baijia.tianxiao.dal.show.po.FieldShowInfo;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * Created by wangsixia on 2016/11/10.
 */
public interface FieldShowInfoDao extends CommonDao<FieldShowInfo>{

    /**
     * 根据条件获取机构字段列表
     * @param orgId 机构id
     * @param type 数据类型:DataProcType
     * @param fieldStatus 字段状态:FieldStatus
     * @param showStatus 显示状态集合:ShowStatus
     * @return
     */
    List<FieldShowInfo> getOrgFieldShow (Long orgId, int type, int fieldStatus, Collection<Integer> showStatus);

    /**
     * 判断机构数据是否初始化
     * @param orgId
     * @param type
     * @return
     */
    boolean hasInit(Long orgId, int type);

    /**
     * 判断上次获取的显示/隐藏字段与数据库中的一致性
     * @param orgId
     * @param type
     * @param lastGetTime 上次获取的时间
     * @return true,数据未改变;false,数据已改变
     */
    boolean consistencyCheck(Long orgId, int type, Date lastGetTime);

    /**
     * 查询锁定字段中最后一个字段的id
     * 由于锁定字段为系统字段,按照顺序插入,且之后不能移动顺序。目前线索和学员的锁定字段仅有姓名、手机号
     * 因此最大的id即为锁定字段中最后一个字段的id
     * @param orgId
     * @param type
     * @return
     */
    Long getLastLockInfo(Long orgId, int type);

    /**
     * 查询正常使用的显示字段中某个字段的后一个字段(唯一)
     * @param orgId
     * @param type
     * @param preId
     * @return
     */
    FieldShowInfo getShowBehind(Long orgId, int type, Long preId, String...queryProps);

    /**
     * 根据自定义字段id获取显示属性
     * @param orgId
     * @param type
     * @param customFieldId
     * @param queryProps
     * @return
     */
    FieldShowInfo getByCustomId(Long orgId, int type, Long customFieldId, String...queryProps);
}
