package com.baijia.tianxiao.dal.roster.po;

import lombok.Data;

import java.util.Date;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

/**   
 * @title       : ConsultCustomSource 
 * @description : 线索自定义来源 
 * @author      : zhenyujian
 * @date        : 2016年7月23日 下午4:15:13 
 */
@Data
@Entity
@Table(name = "tx_consult_custom_source", catalog = "yunying")
public class ConsultCustomSource {
	
	@Id 
    @GeneratedValue
    private Long id;
	
	@Column
    private Long orgId;
	
	@Column
    private String label;
	
	@Column
    private Integer isPaused;
	
	@Column
    private Date createTime;
	
	@Column
    private Date updateTime;
	
	
	
	public static void vaildateLabel(String label){
		if( label.length()>30 ){
    		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "名称最多允许输入30个字符");
    	}
        if( !TxConsultUser.validateStr(label)){
        	throw new ParameterException("名称只允许中英文、数字、括号、下划线、中划线。");
        }
        
        for(MessageSource obj:MessageSource.listConsultSource(null)){
        	if(obj.getDesc().equals(label)){
				throw new ParameterException("指定名称与系统内置文案冲突,请更换名称。");
			}
        }
    }
    
}