/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.roster.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Maps;

/**
 * @author shanyu
 * @version 1.0
 * @title TxRosterCommentDaoImpl
 * @desc TODO
 * @date 2015年12月3日
 */
@Repository
public class TxStudentCommentDaoImpl extends JdbcTemplateDaoSupport<TxStudentComment> implements TxStudentCommentDao {

    public TxStudentCommentDaoImpl() {
        super(TxStudentComment.class);
    }

    @Override
    public List<TxStudentComment> getComments(Long studentId, Long orgId, Integer type, String...queryProps) {
//        SingleSqlBuilder<TxStudentComment> builder = createSqlBuilder(queryProps);
//        if (type.intValue() == StudentType.CONSULT_USER.getCode()) {
//            builder.eq("consultUserId", studentId);
//        } else {
//            builder.eq("userId", studentId);
//        }
//        builder.eq("orgId", orgId);
//        builder.desc("createTime");
//        builder.desc("id");
//        return queryList(builder);
        return this.getCommentList(studentId, orgId, type, null, null, null, queryProps);
    }

    /**
     * 
     * @param studentId
     * @param orgId
     * @param type
     * @param growthComments 是否是成长记录 0:不是 1:是
     * @param lastCommentId
     * @param queryProps
     * @return
     */
    @Override
    public List<TxStudentComment> getCommentList(Long studentId, Long orgId, Integer type, Integer growthComments,
        Integer lastCommentId, PageDto pageDto, String...queryProps) {
        SingleSqlBuilder<TxStudentComment> builder = createSqlBuilder(queryProps);
        if (type.intValue() == StudentType.CONSULT_USER.getCode()) {
            builder.eq("consultUserId", studentId);
        } else {
            builder.eq("userId", studentId);
        }
        if (growthComments != null) {
            builder.eq("growthComments", growthComments);
        }
        if (lastCommentId != null) {
            builder.lt("id", lastCommentId);
        }
        builder.eq("orgId", orgId);
        builder.desc("createTime");
        builder.desc("id");
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return queryList(builder);
    }

    @Override
    public List<Long> getLastDateComments(Long orgId, Date updateTime, String...queryProps) {
        SingleSqlBuilder<TxStudentComment> builder = createSqlBuilder(queryProps);
        builder.select("consultUserId");
        builder.eq("orgId", orgId);
        // 两边数据未同步，暂时将该值取同APP端一致的时间 TODO
        builder.ge("createTime", updateTime);
        builder.groupByNames("consultUserId");
        return queryForList(builder, Long.class);
    }

    @Override
    public List<TxStudentComment> getComments(Long studentId, Long orgId, Integer type, PageDto page,
        String...queryProps) {
        SingleSqlBuilder<TxStudentComment> builder = createSqlBuilder(queryProps);
        if (type.intValue() == StudentType.CONSULT_USER.getCode()) {
            builder.eq("consultUserId", studentId);
        } else {
            builder.eq("userId", studentId);
        }
        builder.eq("orgId", orgId);
        if (null != page) {
            builder.setPage(page);
        }
        builder.desc("createTime");
        builder.desc("id");
        return queryList(builder);
    }

    @Override
    public void updateComment(Long consultUserId, Long userId) {
        SingleSqlBuilder<TxStudentComment> builder = createSqlBuilder();
        builder.eq("consultUserId", consultUserId);
        Map<String, Object> params = Maps.newHashMap();
        params.put("userId", userId);
        params.putAll(builder.collectConditionValue());
        getNamedJdbcTemplate().update(builder.toUpdateSql("userId"), params);
    }


    @Override
    public Map<Long, Integer> getCommentTotal(Date startTime, Date endTime, List<Long> TianxiaoOrgIds,
        Integer isSystemType, Boolean isStudentComment) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id, count(1) count from yunying.tx_student_comment where org_id in (:orgIds) ";
        if (GenericsUtils.notNullAndEmpty(isSystemType)) {
            sql += " and is_system = :isSystemType ";
            param.put("isSystemType", isSystemType);
        }

        if (isStudentComment) {// 获取学员跟进记录
            sql += " and user_id != 0 ";
        }

        if (startTime != null) {
            sql += " and create_time>=:startTime and create_time<=:endTime";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }
        sql += " group by org_id";
        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, Integer>>() {

            @Override
            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Long, Integer> map = new HashMap<>();
                while (rs.next()) {
                    Integer count = rs.getInt("count");
                    Long orgId = rs.getLong("org_id");
                    map.put(orgId, count);
                }
                return map;
            }

        });
    }

    
    
    @Override
    public List<TxStudentComment> listComments(Long studentId, Long orgId, Integer type, Integer isGrowthComment, PageDto pageDto) {
        SingleSqlBuilder<TxStudentComment> builder = createSqlBuilder();
        
        builder.eq("orgId", orgId);
        if (type.intValue() == StudentType.CONSULT_USER.getCode()) {
            builder.eq("consultUserId", studentId);
        } else {
            builder.eq("userId", studentId);
        }
        if (isGrowthComment != null) {
            builder.eq("growthComments", isGrowthComment);
        }
        if(pageDto!=null){
        	builder.setPage(pageDto);
        }
        builder.desc("createTime");
        builder.desc("id");
        
        return queryList(builder);
    }
    
    
    
	@Override
	public Integer countComments(Long studentId, Long orgId, Integer type, Integer isGrowthComment, PageDto pageDto) {
		SingleSqlBuilder<TxStudentComment> builder = createSqlBuilder();
		builder.count("id");
        builder.eq("orgId", orgId);
        if (type.intValue() == StudentType.CONSULT_USER.getCode()) {
            builder.eq("consultUserId", studentId);
        } else {
            builder.eq("userId", studentId);
        }
        if (isGrowthComment != null) {
            builder.eq("growthComments", isGrowthComment);
        }
        
        Integer count = queryForObject(builder, Integer.class);
        return count != null ? count : 0;
	}
}