
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
 */
    
package com.baijia.tianxiao.dal.roster.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.roster.dao.ConsultCustomSourceDao;
import com.baijia.tianxiao.dal.roster.po.ConsultCustomSource;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;


/**   
 * @title       : ConsultCustomSourceImpl 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年7月23日 下午4:24:06 
 */
@Repository
public class ConsultCustomSourceDaoImpl extends JdbcTemplateDaoSupport<ConsultCustomSource> implements ConsultCustomSourceDao{

    public ConsultCustomSourceDaoImpl() {
        super(ConsultCustomSource.class);
    }

	@Override
	public ConsultCustomSource getBy(Long orgId, String label) {
		SingleSqlBuilder<ConsultCustomSource> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("label", label);
        return uniqueResult(builder);
	}


	@Override
	public Map<Long, ConsultCustomSource> map(Long orgId) {
		SingleSqlBuilder<ConsultCustomSource> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        List<ConsultCustomSource> list = queryList(builder);
        
        Map<Long, ConsultCustomSource> map = new HashMap<Long, ConsultCustomSource>();
        if(list!=null){
        	for(ConsultCustomSource source:list){
        		map.put(source.getId(), source);
        	}
        }
        return map;
	}

	@Override
	public List<ConsultCustomSource> list(Long orgId, Integer isPaused) {
		SingleSqlBuilder<ConsultCustomSource> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        if(isPaused!=null){
        	builder.eq("isPaused", isPaused);
        }
        builder.desc("updateTime");
        return queryList(builder);
	}

}

    