/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.roster.dao;

import com.baijia.tianxiao.dal.roster.po.TxStudentTag;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author shanyu
 * @version 1.0
 * @title TxRosterTagDao
 * @desc TODO
 * @date 2015年12月3日
 */

public interface TxStudentTagDao extends CommonDao<TxStudentTag> {

    /**
     * @param studentId
     * @param type(0,咨询本学员;1,花名册学员)
     * @param queryProps
     * @return
     */
    public List<TxStudentTag> getTags(Long studentId, Long orgId, Integer type, String... queryProps);

    public List<TxStudentTag> getTags(Collection<Long> studentIds, Long orgId, Integer type, String... queryProps);


    /**
     * 搜索标签
     *
     * @param orgId
     * @param tagValue
     * @param queryProps
     * @return
     */
    List<Long> searchByTagValue(Long orgId, String tagValue, String... queryProps);

    /**
     * 根据咨询联系人id去更新userId
     *
     * @param consultUserId
     * @param userId
     */
    public void updateTag(Long consultUserId, Long userId);

    /**
     * 批量删除
     */
    public void delTags(Long userId, Long orgId);

    public Map<String, TxStudentTag> getAndCachedTags(Long studentId, Long orgId, Integer type);

    /**
     * 根据id,orgId,studentId,type获取标签(PC-CRM)
     *
     * @param id         主键
     * @param orgId      机构id
     * @param type       学员类型 StudentType: 0,招生线索; 1,学员档案
     * @param studentId  学员id: 与type分别对应咨询用户的id、正式学员的userId
     * @param queryProps
     * @return
     */
    public TxStudentTag getUniqueTag(Long id, Long orgId, Integer type, Long studentId, String... queryProps);


    /**
     * 查询 指定机构热门标签列表
     *
     * @param orgId       机构id
     * @param listSize    查询数量
     * @param minTagTimes 标签最低使用次数(如: minTagTimes=5 表示 至少使用过5次才被算作热门标签)
     * @author zhenyujian
     */
    List<TxStudentTag> getHotTags(Long orgId, Integer listSize, Integer minTagTimes);

    void delTagsByConsulterId(Long consulterId, Long orgId);
    
    /**
     * 根据consultId获取线索所有标签
     */
    List<TxStudentTag> getTagsByConsultId(Long consultId, Long orgId);
}
