/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.roster.dao;

import java.util.Date;
import java.util.List;

import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Map;

/**
 * @author shanyu
 * @version 1.0
 * @title TxRosterCommentDao
 * @desc TODO
 * @date 2015年12月3日
 */

public interface TxStudentCommentDao extends CommonDao<TxStudentComment> {

    /**
     * 根据id获取备注
     *
     * @param studentId
     * @param type(0,咨询本学员;1,花名册学员)
     * @param queryPropes
     * @return
     */
    List<TxStudentComment> getComments(Long studentId, Long orgId, Integer type, String... queryPropes);

    /**
     * 跟进时间过去机构最近7天跟进学员ID
     *
     * @param orgId
     * @param updateTime
     * @param queryProps
     * @return
     */
    List<Long> getLastDateComments(Long orgId, Date updateTime, String... queryProps);

    /**
     * 分页查询跟进记录
     *
     * @param studentId
     * @param type(0,咨询本学员;1,花名册学员)
     * @param page:                 null则不分页
     * @param queryPropes
     * @return
     */
    List<TxStudentComment> getComments(Long studentId, Long orgId, Integer type, PageDto page, String... queryPropes);

	/**
	 * 获取机构跟进记录数
	 * @param isSystemType 是否是系统添加
	 * @param isStudentComment 是否获取学员记录 ，false 获取总记录
	 */
	public Map<Long, Integer> getCommentTotal(Date startTime, Date endTime, List<Long> TianxiaoOrgIds, Integer isSystemType, Boolean isStudentComment);

    /**
     * 根据咨询联系人id更新学生userId
     *
     * @param consultUserId 联系人Id
     * @param userId
     */
    void updateComment(Long consultUserId, Long userId);


    /**
     * @param studentId
     * @param orgId
     * @param type
     * @param growthComments
     * @param lastCommentId
     * @param pageDto
     * @param queryProps
     * @return
     */
    List<TxStudentComment> getCommentList(Long studentId, Long orgId, Integer type, Integer growthComments,
        Integer lastCommentId, PageDto pageDto, String... queryProps);
    Integer countComments(Long studentId, Long orgId, Integer type, Integer isGrowthComment, PageDto pageDto);
    List<TxStudentComment> listComments(Long studentId, Long orgId, Integer type, Integer isGrowthComment, PageDto pageDto);
}
