/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.roster.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dto.query.AutoMatchQueryRequest;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/**
 * @author shanyu
 * @version 1.0
 * @title TxRosterDao
 * @desc TODO
 * @date 2015年12月3日
 */

public interface TxConsultUserDao extends CommonDao<TxConsultUser> {

    /**
     * 根据用户id查找 userId
     *
     * @param orgId
     * @param useId
     * @param queryProp
     * @return
     */
    List<TxConsultUser> lookByUserId(Long orgId, Long useId, String...queryProp);

    /**
     * 根据studentId查询对应咨询用户
     *
     * @param orgId
     * @param studentId
     * @param queryProp
     * @return
     */
    List<TxConsultUser> lookByStudentId(Long orgId, Long studentId, String...queryProp);

    /**
     * 根据手机号码查询机构咨询用户
     *
     * @param orgId
     * @param mobile
     * @param queryProp
     * @return
     */
    List<TxConsultUser> lookByParams(Long orgId, String weixinOpenId, String...queryProp);

    /**
     * 根据微信openId、mobile查询机构学院
     *
     * @param orgId 机构ID
     * @param mobile 学员手机号
     * @param weixinOpenId
     * @param queryProp
     * @return
     */
    TxConsultUser lookByParams(Long orgId, String mobile, String weixinOpenId, String...queryProp);

    /**
     * 根据手机号查找用户
     *
     * @param mobile
     * @param queryProp
     * @return
     */
    List<TxConsultUser> lookByMobile(Long orgId, String mobile, String...queryProp);

    List<TxConsultUser> lookByMobiles(Long orgId, Collection<String> mobiles, String...queryProp);

    /**
     * 根据微信的openId查找用户
     *
     * @param weixinOpenId
     * @param queryProp
     * @return
     */
    List<TxConsultUser> lookByWeixinOpenId(Long orgId, String weixinOpenId, String...queryProp);

    List<TxConsultUser> lookByWeixinOpenIds(Long orgId, Collection<String> weixinOpenIds, String...queryProp);

    /**
     * 根据条件搜索用户
     *
     * @param type 咨询用户类型: 0,非正式学员的咨询用户; 1,正式学员的咨询用户; null,不区分
     * @param key 咨询的客户的手机号,姓名,昵称
     * @param intensionLevel
     * @param startTime
     * @param endTime
     * @param page
     * @return
     */
    List<TxConsultUser> search(Integer type, String key, Long orgId, Integer casCadeId, Integer intensionLevel,
        Collection<Integer> consultSources, Date startTime, Date endTime, PageDto page, String...queryProp);

    /**
     * 同步数据用
     *
     * @param minId
     * @param lastDate
     * @param maxSize
     * @param queryProps
     * @return
     */
    List<TxConsultUser> getOrgConsultUserListByMinId(Long minId, Date lastDate, int maxSize, String...queryProps);

    /**
     * 根据更新时间
     *
     * @param minId
     * @param lastDate
     * @param maxSize
     * @param queryProps
     * @return
     */
    List<TxConsultUser> getOrgConsultUserListByUpdateTime(Long minId, Date lastDate, int maxSize, String...queryProps);

    /**
     * @Description : 查询微信粉丝对应的咨询用户id
     * @Author : zhenyujian
     * @Date : 2015年12月17日 下午4:15:06
     * @Return : Map<String,Long>
     */
    Map<String, TxConsultUser> mapKeyOpenIdValueId(Integer orgId, List<String> openIdList);

    /**
     * 获取需要提醒的用户信息
     *
     * @return
     * @Author liuxiaopeng
     */
    List<TxConsultUser> getConsultUserByRemindTime(Date startTime);

    /**
     * 获取需要提醒的用户信息
     *
     * @return
     * @Author liuxiaopeng
     */
    List<TxConsultUser> getConsultUserByRemindTime(Date startTime, Date endTime);

    /**
     * 查询机构咨询用户
     *
     * @param orgId 机构ID
     * @param id 咨询用户ID
     * @return
     */
    TxConsultUser getOrgConsultUser(Long orgId, Long id);

    /**
     * @param pageDto
     * @return
     */
    List<TxConsultUser> searchHasMobileConsulter(PageDto pageDto, String format, String value);

    /**
     * 根据指定属性的key-value分页查询意向学员信息
     *
     * @param pageDto
     * @return
     */
    List<TxConsultUser> searchConsultByCustomParam(long orgId, AutoMatchQueryRequest params, Integer cascadeId,
        Integer isInvalid, List<Long> inConsultUserIds, List<Long> notInConsultUserIds, PageDto pageDto);

    /**
     * 刷新体验账号数据
     *
     * @param orgId
     * @param id
     */
    void refreshConsultUser(Long orgId, Long id);

    /**
     * 获取意向学员数量
     */
    Map<Long, Integer> getConsultUserTotal(Date startDate, Date endDate, List<Long> TianxiaoOrgIds);

    /**
     * 根据ids获取意向学员详情
     */
    Map<Long, TxConsultUser> getConsultUserByIds(Long orgId, Collection<Long> ids, Integer deleteStatus);

    /**
     * 获取学员userIds
     */
    Map<Long, Long> getUserIdMapByIds(Long orgId, Set<Long> ids);

    /**
     * 根据条件进行不同访客数据的统计
     *
     * @param orgId
     * @param isConsulter 是否是线索 0否
     * @param followStatuss 跟进状态值 0:已联系,1:未沟通, 2:邀约上门, 3:预约试听, 4:已交定金, 5:已丢单, 6:无效
     * @param intentionLevels 意向级别:0.1低， 2.3中， 4.5高
     * @return
     */
    Integer statisticTotalConsultByCondition(Long orgId, Integer isConsulter, List<Integer> followStatuss,
        List<Integer> intentionLevels, Date startTime, Date endTime);

    List<TxConsultUser> searchConsultUsersByCondition(Long orgId, Integer isConsulter, List<Integer> followStatuss,
        List<Integer> intentionLevels, Date startTime, Date endTime, Integer start, Integer limit);

    /**
     * 根据id获取详情
     * 
     * @param id
     * @return
     */
    TxConsultUser getOrgConsultUser(Long id);

    Integer countConsulter(Long orgId, Long cascadeId);

    /**
     * 分页获取意向学员
     */
    List<TxConsultUser> getPageTxConsultUsersByIds(Collection<Long> ids, PageDto pageDto);
    
    /**
     * 根据studentIds分页获取意向学员
     */
    List<TxConsultUser> getPageTxConsultUserByStudentIds(Long orgId, Collection<Long> studentIds,
        final PageDto pageDto);

    /**
     * 批量获取意向学员
     * 
     * @param delStatus  删除状态
     * @param status 用户状态 当是访客时除去线索 可以传null
     */
    List<TxConsultUser> batchTxConsultUserByIds(Collection<Long> ids, Integer delStatus, Integer status);

    List<Long> listConsulterUserIdsNeedToRelease(Date releaseTime);

    int release(List<Long> ids, Date releaseTime);

    List<Long> listConsulterUserIdsByCascade(Long cascadeId);

    public List<TxConsultUser> getUsersByPage(PageDto pageDto);

    public Integer countBySource(Long orgId, Long sourceId);

    public void replacePortrait(String oldUrl, String newUrl);

    List<TxConsultUser> listOpenIdNotNull(Long minId);

    /**
     * @param cascadeIds
     * @param orgId
     * @param isConsulter
     * @param isInvalid
     * @param pageDto
     * @return
     */
    List<TxConsultUser> queryConsulters(Set<Integer> cascadeIds, Long orgId, Integer consulterType, Integer isConsulter,
        Integer isInvalid, PageDto pageDto);

    /**
     * @param cascadeIds
     * @param orgId
     * @param consulterType
     * @param isConsulter
     * @param isInvalid
     * @return
     */
    int countOutLine(Set<Integer> cascadeIds, Long orgId, Integer consulterType, Integer isConsulter,
        Integer isInvalid);
    
    Map<Long,String> mapIdVsName(Collection<Long> ids);
}
