package com.baijia.tianxiao.dal.roster.dao;

import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author Rezar
 * @createDate :Jul 19, 2016 10:14:34 PM
 * @desc :
 */
public interface CustomFieldValueDao extends CommonDao<CustomFieldValue> {

    /**
     * 根据机构Id,客户数据类型以及客户id来查找当前存储的自定义的值
     * 
     * @param orgId
     * @param isStudent
     * @param studentId
     * @param customFieldConfigs
     * @return
     */
    List<CustomFieldValue> searchValuesByConfig(Long orgId, boolean isStudent, Long studentIdOrConsultId, List<Long> customFieldIds);
    
    CustomFieldValue getCustomFieldValue(Long fieldId, boolean isStudent, Long studentIdOrConsultId);
    
    void updateStudentId(Long orgId, Long consultId, Long studentId);

    /**
     * 批量获取线索/学员的自定义字段值列表
     * @param orgId
     * @param isStudent
     * @param coll 线索/学员的id
     * @param customFieldIds
     * @return
     */
    public Map<Long, List<CustomFieldValue>> batchGetValueMap(Long orgId, boolean isStudent, Collection<Long> coll, Collection<Long> customFieldIds);
}
