package com.baijia.tianxiao.dal.roster.dao;

import com.baijia.tianxiao.dal.roster.po.CustomField;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.List;

/**
 * @author Rezar
 * @createDate :Jul 19, 2016 10:13:10 PM
 * @desc :
 */
public interface CustomFieldDao extends CommonDao<CustomField> {
    /**
     * 获取所有未删除字段
     * @param isSystem 是否是系统字段 0：否，1是
     */
    public List<CustomField> getCustomFieldList(Long orgId, Integer isSystem);

    /**
     * 获取字段详情
     * 
     * @param Long fieldId
     * @param Long orgId
     */
    public CustomField getCustomFieldById(Long orgId, Long fieldId);

    public List<CustomField> getCustomFieldsByOrgId(Long orgId);

    boolean hasInitSystemField(Long orgId);

    void batchInsert(List<CustomField> generatorCustomFields);

    List<CustomField> getCustomFieldListWithCondition(Long orgId, Boolean isPaused);

}
