
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.roster.constant;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.commons.ConfigEnum;
import com.google.common.collect.Maps;

/**
 * @title CommentType
 * @desc 跟进记录 沟通方式
 * @date 2016年5月25日
 * @version 1.0
 */

public enum CommentType {

    DIANHU(1, "电话沟通", ""),
    YUYUEGOUTONG(2, "预约沟通", ""),
    WEIXIN(3, "微信沟通", ""),
    OTHER(4, "其他", ""),
    ;

    private int value;
    private String label;
    private String img;
    
    private static Map<Integer, String> map = Maps.newHashMap();

    static {
        for (CommentType p : values()) {
            map.put(p.getValue(), p.getLabel());
        }
    }

    public static String getLabel(int value) {
        return  map.get(value);
    }
    
    
    private CommentType(int value, String label, String img) {
        this.value = value;
        this.label = label;
        this.img = img;
    }

    public int getValue() {
        return value;
    }

    
    public String getLabel() {
        return label;
    }
    
    public String getImg(){
    	return img;
    }
    
    public static List<ConfigEnum> list(){
    	List<ConfigEnum> list = new ArrayList<ConfigEnum>();
    	for (CommentType p : values()) {
    		 ConfigEnum po = new ConfigEnum();
    		 po.setValue(p.getValue());
    		 po.setLabel(p.getLabel());
    		 po.setImg(p.getImg());
    		 list.add(po);
    	}
    	return list;
    }
    
    public static List<Integer> listValues(){
    	List<Integer> list = new ArrayList<Integer>();
    	for (CommentType p : values()) {
    		 list.add(p.getValue());
    	}
    	return list;
    }
    
}
