package com.baijia.tianxiao.dal.push.utils;

import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.baijia.tianxiao.dal.push.constant.CardType;
import com.baijia.tianxiao.dal.push.dto.content.AudioMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.CardMsgContent;

/**
 * Created by liuxp on 16/6/3.
 */
public class CardContentFactory {
    public static CardMsgContent createAppointCard(String name,String mobile,String text){
        CardMsgContent content = new CardMsgContent();
        StringBuilder sb = new StringBuilder();
        sb.append("姓名：").append(name).append("\n")
                .append("电话：").append(mobile).append("\n")
                .append("留言：").append(text);
        content.setText(sb.toString());
        content.setTitle("预约留单");
        content.setType(CardType.APPOINTMENT.getValue());
        return content;
    }

    public static CardMsgContent createActivityCard(String name,String mobile,String text){
        CardMsgContent content = new CardMsgContent();
        StringBuilder sb = new StringBuilder();
        sb.append("姓名：").append(name).append("\n")
                .append("电话：").append(mobile).append("\n")
                .append("活动名称：").append(text);
        content.setText(sb.toString());
        content.setTitle("活动");
        content.setType(CardType.ACTIVITY_ENROLL.getValue());
        return content;
    }

    public static CardMsgContent createTelephoneCard(String text,String url,Integer length,Long storageId,Long callId){
        CardMsgContent content = new CardMsgContent();
        content.setTitle("致电访问");
        if(callId!=null && callId>0){
            AudioMsgContent audio = new AudioMsgContent();
            audio.setLen(length == null ? 0 : length);
            if(storageId!=null) {
                audio.setStorageId(storageId);
            }
            audio.setUrl(url);
            audio.setCallId(callId);
            content.getAudios().add(audio);
        }
        content.setText(text);
        content.setType(CardType.TELEPHONE.getValue());
        return content;
    }

    public static CardMsgContent createActivityCard(String text,String url,Integer length,Long storageId){
        CardMsgContent content = new CardMsgContent();
        content.setTitle("活动");
        if(StringUtils.isNotBlank(url)){
            AudioMsgContent audio = new AudioMsgContent();
            audio.setLen(length);
            audio.setStorageId(storageId);
            audio.setUrl(url);
            content.getAudios().add(audio);
        }
        content.setText(text);
        content.setType(CardType.APPOINTMENT.getValue());
        return content;
    }

    public static CardMsgContent createCourseCard(String text,String url,Integer length,Long storageId,Map<String,Object> payload){
        CardMsgContent content = new CardMsgContent();
        content.setTitle("课程");
        if(StringUtils.isNotBlank(url)){
            AudioMsgContent audio = new AudioMsgContent();
            audio.setLen(length);
            audio.setStorageId(storageId);
            audio.setUrl(url);
            content.getAudios().add(audio);
        }
        content.setText(text);
        content.setType(CardType.COURSE.getValue());
        return content;
    }


}
