package com.baijia.tianxiao.dal.push.dto.content;

import com.baijia.tianxiao.dal.push.constant.NoticeType;
import lombok.Data;

/**
 * Created by liuxp on 16/5/24.
 */
@Data
public class NoticeMsgContent implements MsgContent {
    private String action;
    private String title;
    private int type;
    private String text;

    public static NoticeMsgContent createNoticeContent(NoticeType type, String action) {
        return createNoticeContent(type, action, type.getContent());
    }

    public static NoticeMsgContent createNoticeContent(NoticeType type, String action, String text) {
        NoticeMsgContent content = new NoticeMsgContent();
        content.setTitle(type.getTitle());
        content.setText(text);
        content.setType(type.getType());
        content.setAction(action);
        return content;
    }
}
