package com.baijia.tianxiao.dal.push.constant;

/**
 * Created by liuxp on 16/5/24.
 */
public enum NoticeType {
    PUBLIC_CLUE(1,"公海线索","公海有新线索，您可以查看"),
    RECEIVE_CLUE(2,"收到线索","同事转给你一条新线索"),
    TO_DO(3,"待办事项","您有一条待办事项"),
    NEW_ALLOCATE(4,"新分配线索","收到新分配线索，你可以查看"),
    CALL(5,"400来电","您有一条400来电"),
    BATCH_IMPORT(6,"公海线索","公海有新的批导线索"),
    RECEIVE_STUDENT(7,"转交学员","同事转给您一名学员")
    ;

    private int type;
    private String title;
    private String content;

    NoticeType(int type, String title, String content) {
        this.type = type;
        this.title = title;
        this.content = content;
    }

    public int getType() {
        return type;
    }

    public String getContent() {
        return content;
    }

    public String getTitle() {
        return title;
    }

    public static NoticeType getByValue(int value){
        for (NoticeType type:NoticeType.values()){
            if (type.type == value){
                return type;
            }
        }
        return null;
    }

    public static String getTips(String name){
        return "公海有新线索，姓名："+name;
    }
}
