package com.baijia.tianxiao.dal.push.constant;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/6/21.
 */
@Slf4j
public enum MsgUserType {
    STUDENT(1, "学生"),
    ORG(2, "机构"),
    SYSTEM(3, "系统"),
    UNKNOWN(4, "未知");

    private int value;
    private String desc;

    private MsgUserType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public static MsgUserType getUserType(MsgUserRole role) {
        if (role != null && MsgUserRole.isStu(role.getValue())) {
            return MsgUserType.STUDENT;
        }
        if (role != null && MsgUserRole.isOrg(role.getValue())) {
            return ORG;
        }
        if (role != null && MsgUserRole.SYSTEM.getValue() == role.getValue()) {
            return SYSTEM;
        }
        log.warn("MsgUserRole is error." + role);
        return UNKNOWN;
    }

    public static MsgUserType getUserType(int userRole) {
        MsgUserRole role = MsgUserRole.getByCode(userRole);
        return getUserType(role);
    }
}
