package com.baijia.tianxiao.dal.push.constant;

import com.baijia.tianxiao.dal.roster.constant.ConsulterStatus;

import com.google.common.collect.Maps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by liuxp on 15/12/7.
 */
public enum MsgUserRole {
    HEADER(1,"校长"),
    BRANCH_HEADER(2,"分校校长"),
    MANAGER(3,"主管"),
    STAFF(4,"普通员工"),

    CONSULT(101,"咨询学员"),
    CLUE(102,"线索"),
    STUDENT(103,"正式学员"),

    SYSTEM(10000,"系统");

    private static final Set<MsgUserRole> stuSet = new HashSet<>();
    private static final Set<MsgUserRole> orgSet = new HashSet<>();
    
    private static final Set<MsgUserRole> orgHeadRoleSet = new HashSet<>();
    private static final Set<MsgUserRole> cascadeRoleSet = new HashSet<>();
    static {

        stuSet.add(CONSULT);
        stuSet.add(CLUE);
        stuSet.add(STUDENT);

        orgSet.add(STAFF);
        orgSet.add(MANAGER);
        orgSet.add(BRANCH_HEADER);
        orgSet.add(HEADER);
        
        orgHeadRoleSet.add(BRANCH_HEADER);
        orgHeadRoleSet.add(HEADER);
        
        cascadeRoleSet.add(STAFF);
        cascadeRoleSet.add(MANAGER);
    }

    private int value;
    private String desc;
    private MsgUserRole(int value, String desc){
        this.value = value;
        this.desc = desc;
    };
    
    private static Map<Integer, MsgUserRole> mapping = Maps.newHashMap();
    
    private static Map<String, MsgUserRole> mappingDesc = Maps.newHashMap();
    
    static{
        for(MsgUserRole cut : MsgUserRole.values()){
            mapping.put(cut.value, cut);
        }
    }
    
    static{
        for(MsgUserRole cut : MsgUserRole.values()){
            mappingDesc.put(cut.desc, cut);
        }
    }
    
    public static MsgUserRole getByCode(Integer code) {
        return mapping.get(code);
    }
    
    public static MsgUserRole getByDesc(String desc){
        return mappingDesc.get(desc);
    }

    public int getValue(){
        return value;
    }

    public String getDesc(){
        return desc;
    }

    /**
     * 学员类用户
     * @return
     */
    public static Set<MsgUserRole> getStuUsers(){

        return  Collections.unmodifiableSet(stuSet);
    }

    /**
     * 机构用户
     * @return
     */
    public static Set<MsgUserRole> getOrgUsers(){

        return Collections.unmodifiableSet(orgSet);
    }
    
    /**
     * 机构校长用户
     */
    public static Set<MsgUserRole> getOrgHeadUsers(){
        return Collections.unmodifiableSet(orgHeadRoleSet);
    }
    
    /**
     * 子帐号用户
     */
    public static Set<MsgUserRole> getCascadeUsers(){
        return Collections.unmodifiableSet(cascadeRoleSet);
    }

    /**
     * 是否为校长
     * @param value
     * @return
     */
    public static boolean isHeader(int value){
        if(value==HEADER.value || value==BRANCH_HEADER.value){
            return true;
        }else {
            return false;
        }
    }

    /**
     * 是否子账号
     * @param value
     * @return
     */
    public static boolean isSubOrg(int value){
        if(value==MANAGER.value || value==STAFF.value){
            return true;
        }else {
            return false;
        }
    }

    /**
     * 是否为机构
     * @param value
     * @return
     */
    public static boolean isOrg(int value){
        MsgUserRole type = getByCode(value);
        return orgSet.contains(type);
    }

    public static boolean isStu(int value){
        MsgUserRole type = getByCode(value);
        return stuSet.contains(type);
    }

    public static MsgUserRole getUserRole(int consulterStatus){
        if(consulterStatus== ConsulterStatus.IS.getValue()){
            return CLUE;
        }else {
            return CONSULT;
        }
    }
    
    public static List<Integer> getRoles(Collection<MsgUserRole> roleTypes){
        List<Integer> roles = new ArrayList<>();
        for(MsgUserRole msgUserRole : roleTypes){
            Integer role = msgUserRole.getValue();
            roles.add(role);
        }
        return roles;
    }
    
    public static String getText(MsgUserRole userType){
        switch (userType) {
            case CONSULT:
                return "咨询";
            case STUDENT:
                return "学员";
            case CLUE:
                return "线索";
            case SYSTEM:
                return "系统";
            case HEADER:
            case BRANCH_HEADER:
            case MANAGER:
            case STAFF:
                return "同事";
        }
        return "";
    }
}
