package com.baijia.tianxiao.dal.push.constant;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by liuxp on 15/12/7.
 */
public enum  MsgType {
    TEXT(0,"文本"), PICTURE(1,"图片"), VOICE(2,"语音"), LOCATION(3,"位置"), CARD(5,"卡片"),NOTICE(100,"通知");

    private int value;
    private String desc;
    private MsgType(int value,String desc){
        this.value = value;
        this.desc = desc;
    };

    public int getValue(){
        return value;
    }

    public String getDesc(){
        return desc;
    }

    private static Map<Integer, MsgType> mapping = Maps.newHashMap();
    
    static {
        for (MsgType ct : MsgType.values()) {
            mapping.put(ct.value, ct);
        }
    }
    
    public static MsgType getByType(Integer value) {
        return mapping.get(value);
    }

    public static MsgType getTypeByValue(int value){
        for (MsgType type:MsgType.values()){
            if(type.value==value){
                return type;
            }
        }
        return null;
    }
}
