package com.baijia.tianxiao.dal.push.constant;

/**
 * Created by liuxp on 16/6/3.
 */
public enum CardType {

    APPOINTMENT(1,"留单卡片"),
    TELEPHONE(2,"400来电卡片"),
    ACTIVITY(3,"活动卡片"),
    COURSE(4,"课程卡片"),
    FOLLOW(5,"跟进记录卡片"),
    ACTIVITY_ENROLL(6,"活动报名");

    private int value;
    private String desc;
    private CardType(int value, String desc){
        this.value = value;
        this.desc = desc;
    };

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
    
    public static CardType getTypeByValue(int value){
        for (CardType type:CardType.values()){
            if(type.value==value){
                return type;
            }
        }
        return null;
    }
}
