/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.pcAuthority.dao.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.pcAuthority.dao.TxRolePermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.TxRolePermission;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

/**
 * @title TxRolePermissionDaoImpl
 * @desc description
 * @author hongyan
 * @date 2016年8月1日
 * @version version
 */
@Repository
public class TxRolePermissionDaoImpl extends JdbcTemplateDaoSupport<TxRolePermission> implements TxRolePermissionDao {

    public TxRolePermissionDaoImpl() {
        super(TxRolePermission.class);
    }

    @Override
    public List<TxRolePermission> getTxRolePermissionsByVipLevelAndRole(Integer vipLevel, Integer role,Integer deviceType) {
        SingleSqlBuilder<TxRolePermission> builder = createSqlBuilder();
        if (null != vipLevel)
            builder.eq("vip_level", vipLevel);
        if (null != role)
            builder.eq("role", role);
        if (null != deviceType)
            builder.eq("device_type", deviceType);
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        return queryList(builder);
    }

    @Override
    public List<TxRolePermission> getTxRolePermissionsByVipLevelAndRole(Integer vipLevel, Integer role) {
        SingleSqlBuilder<TxRolePermission> builder = createSqlBuilder();
        if (null != vipLevel)
            builder.eq("vip_level", vipLevel);
        if (null != role)
            builder.eq("role", role);
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        return queryList(builder);
    }

    @Override
    public List<TxRolePermission> getTxRolePermissionsByCodes(Integer vipLevel, Integer role,
        Collection<Long> pCodes) {
        SingleSqlBuilder<TxRolePermission> builder = createSqlBuilder();
        if (null != vipLevel)
            builder.eq("vip_level", vipLevel);
        if (null != role)
            builder.eq("role", role);
        if (!org.apache.commons.collections4.CollectionUtils.isEmpty(pCodes)) {
            builder.in("p_code", pCodes);
        }
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        return queryList(builder);
    }

}
