package com.baijia.tianxiao.dal.pcAuthority.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.pcAuthority.dao.TxAccountPermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.TxAccountPermission;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;

/**
 * @author Rezar
 * @createDate :Jun 1, 2016 10:17:38 AM
 * @desc :
 */
@Repository
public class TxAccountPermissionDaoImpl extends JdbcTemplateDaoSupport<TxAccountPermission>
    implements TxAccountPermissionDao {

    @Override
    public List<TxAccountPermission> listAllConfigs(Integer pType, Integer deviceType, Integer uId, Integer uType) {

        SingleSqlBuilder<TxAccountPermission> builder = createSqlBuilder();
        if (pType != null) {
            builder.eq("pType", pType);
        }
        if (deviceType != null) {
            builder.eq("deviceType", deviceType);
        }
        builder.eq("uId", uId);
        builder.eq("uType", uType);

        List<TxAccountPermission> queryList = queryList(builder);
        if (queryList == null) {
            queryList = Collections.emptyList();
        }
        return queryList;
    }

    @Override
    public TxAccountPermission getTxAccountPermission(Integer pId, Integer deviceType, Integer uId) {
        SingleSqlBuilder<TxAccountPermission> builder = createSqlBuilder();
        builder.eq("pId", pId);
        builder.eq("uId", uId);
        builder.eq("deviceType", deviceType);
        List<TxAccountPermission> queryList = this.queryList(builder);
        if(GenericsUtils.notNullAndEmpty(queryList)){
            return queryList.get(0);
        }else{
            return null;
        }
    }

    @Override
    public List<TxAccountPermission> selectPermission(List<Integer> cascadeIds, Long code) {
        if (GenericsUtils.isNullOrEmpty(cascadeIds)) {
            return Collections.emptyList();
        }
        String sql = "select ap.uid,ap.p_type from yunying.tx_account_permission ap left join "
            + "yunying.tx_permission_new_3 p on ap.p_id = p.id where ap.uid in (:cascadeIds) and p.code = :code";
        Map<String, Object> param = new HashMap<>();
        param.put("cascadeIds", cascadeIds);
        param.put("code", code);
        return getNamedJdbcTemplate().query(sql, param, new RowMapper<TxAccountPermission>() {
            @Override
            public TxAccountPermission mapRow(ResultSet rs, int rowNum) throws SQLException {
                TxAccountPermission permission = new TxAccountPermission();
                permission.setUId(rs.getInt("uid"));
                permission.setPType(rs.getInt("p_type"));
                return permission;
            }
        });
    }

    @Override
    public List<TxAccountPermission> geTxAccountPermission(Integer pId, Integer uId) {
        SingleSqlBuilder<TxAccountPermission> builder = createSqlBuilder();
        builder.eq("pId", pId);
        builder.eq("uId", uId);
        return queryList(builder);
    }
    
    @Override
    public List<TxAccountPermission> geTxAccountPermission(List<Integer> pId, Integer uId) {
        SingleSqlBuilder<TxAccountPermission> builder = createSqlBuilder();
        builder.in("pId", pId);
        builder.eq("uId", uId);
        return queryList(builder);
    }
}
