package com.baijia.tianxiao.dal.pcAuthority.constant;

import java.util.ArrayList;
import java.util.List;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;

/**
 * @author Rezar
 * @createDate :May 30, 2016 12:33:02 AM
 * @desc :
 */
public enum RoleType {

    CHARAGE(3, 2.0, "主管"), EMPLOYEE(4, 3.0, "员工"), PRESIDENT(1, 0.0, "总校校长"), BRANCH_SCH_PRESIDENT(2, 1.0, "分校校长");

    public Integer type;
    public Double weight;
    public String desc;

    private static BiMap<Integer, RoleType> typeInfos = HashBiMap.<Integer, RoleType> create();

    static {
        RoleType[] values = RoleType.values();
        for (RoleType value : values) {
            typeInfos.put(value.type, value);
        }
    }

    private RoleType(Integer typeValue, Double weight, String desc) {
        this.type = typeValue;
        this.weight = weight;
        this.desc = desc;
    }

    public static Integer getType(RoleType typeEnum) {
        return typeInfos.inverse().get(typeEnum);
    }

    public static RoleType getRoleType(Integer typeValue) {
        return typeInfos.get(typeValue);
    }

    /**
     * 获取下级
     * 
     * @param weight
     * @return
     */
    public static List<RoleType> getSubRoleTypes(RoleType superRole) {
        List<RoleType> subRoleTypes = new ArrayList<>();
        Double weight = superRole.weight;
        for (RoleType rt : RoleType.values()) {
            if (rt.weight > weight) {
                subRoleTypes.add(rt);
            }
        }
        return subRoleTypes;
    }

}
