package com.baijia.tianxiao.dal.pcAuthority.constant;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;

/**
 * @author Rezar
 * @createDate :May 29, 2016 10:43:48 PM
 * @desc :
 */
public enum PMasterType {

    USER(0, "用户"), ROLE(1, "角色");

    public Integer type;
    public String desc;

    private static BiMap<Integer, PMasterType> typeInfos = HashBiMap.<Integer, PMasterType> create();

    static {
        PMasterType[] values = PMasterType.values();
        for (PMasterType value : values) {
            typeInfos.put(value.type, value);
        }
    }

    private PMasterType(Integer typeValue, String desc) {
        this.type = typeValue;
        this.desc = desc;
    }

    public static Integer getType(PMasterType typeEnum) {
        return typeInfos.inverse().get(typeEnum);
    }

    public static PMasterType getPMasterType(Integer typeValue) {
        return typeInfos.get(typeValue);
    }

}
