package com.baijia.tianxiao.dal.pcAuthority.constant;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;

/**
 * @author Rezar
 * @createDate :May 30, 2016 1:05:53 AM
 * @desc :
 */
public enum PAccessType {

    PC_AUTH(0, "tx_menu_auth");

    public Integer type;
    public String desc;

    private static BiMap<Integer, PAccessType> typeInfos = HashBiMap.<Integer, PAccessType> create();

    static {
        PAccessType[] values = PAccessType.values();
        for (PAccessType value : values) {
            typeInfos.put(value.type, value);
        }
    }

    private PAccessType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static Integer getType(PMasterType typeEnum) {
        return typeInfos.inverse().get(typeEnum);
    }

    public static PAccessType getPMasterType(Integer typeValue) {
        return typeInfos.get(typeValue);
    }

}
