package com.baijia.tianxiao.dal.pcAuthority.constant;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;

/**
 * @author Rezar
 * @createDate :May 30, 2016 10:34:45 AM
 * @desc : 系统类型
 */
public enum ApplicationType {

    APP(0, "APP"), PC(1, "PC");

    public Integer type;
    public String desc;

    private static BiMap<Integer, ApplicationType> typeInfos = HashBiMap.<Integer, ApplicationType> create();

    static {
        ApplicationType[] values = ApplicationType.values();
        for (ApplicationType value : values) {
            typeInfos.put(value.type, value);
        }
    }

    private ApplicationType(Integer type, String desc) {
        this.type = type;
    }

    public static Integer getType(PMasterType typeEnum) {
        return typeInfos.inverse().get(typeEnum);
    }

    public static ApplicationType getApplicationType(Integer typeValue) {
        return typeInfos.get(typeValue);
    }
    
    public Integer getType() {
        return this.type;
    }
}
