package com.baijia.tianxiao.dal.org.po;

import java.util.Date;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

/**
 * 机构视频存储表
 * @title OrgVideoStorage
 * @desc TODO 
 * @author zhangbing
 * @date 2014年12月9日
 * @version 1.0
 */
@Data
@Table(name = "org_video_storage", catalog = "yunying")
public class OrgVideoStorage {

    //主键
    @Id
    @GeneratedValue
    private Long id;
    
    @Column
    private Integer org_id;
    
    //视频id
    @Column
    private Integer video_id;
    
    //视频上传url
    @Column
    private String upload_url;
    
    //视频上传进度查询地址
    @Column
    private String progress_url;
    
    //token
    @Column
    private String token;
    
    //是否分片上传，0不分片，1分片
    @Column
    private Integer uploadtype;
    
    //视频唯一标识码
    @Column
    private String video_unique;
    
    //视频名称
    @Column
    private String video_name;
    
    //视频封面url
    @Column
    private String img;
    
    //视频自定义截图URL地址，默认为空
    @Column
    private String init_pic;
    
    //视频是否收费：0表示不收费；1表示收费
    @Column
    private Integer is_pay;
    
    //视频时长
    @Column
    private Integer video_duration;
    
    //上传文件原始大小，单位为字节
    @Column
    private Long initial_size;
    
    //视频添加时间，格式为：yyyy-mm-dd hh:mm:ss
    @Column
    private Date upload_time;
    
    //上传完毕时间，格式为：yyyy-mm-dd hh:mm:ss
    @Column
    private Date complete_time;
    
    //视频简介
    @Column
    private String video_desc;
    
    //标签
    @Column
    private String tag;
    
    //视频源文件的MD5值
    @Column
    private String md5;
    
    //视频状态：10表示可以正常播放；20表示处理失败；30表示正在处理过程中
    @Column
    private Integer status;
    
    //视频来源：机构
    @Column
    private Integer video_src;
    
    //视频系统视频主键
    @Column
    private Integer fid;
    
    //视频来源：0-乐视,1-内部视频
    @Column
    private Integer source;

    
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
}
