/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2014 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.org.po;

import com.baijia.tianxiao.dal.org.constant.MIMEType;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import lombok.Data;

/**
 * @title : OrgStorage
 * @description :
 * @author : zhenyujian
 * @date : 2015年12月4日 下午5:57:36
 */
@Entity
@Table(name = "org_storage", catalog = "yunying")
@Data
public class OrgStorage {

    @Id
    @GeneratedValue
    private Integer id;

    @Column(name = "fid")
    private String fid;

    @Column(name = "sn")
    private String sn;

    @Column(name = "size")
    private Integer size;

    @Column(name = "mimetype")
    private Integer mimeType;

    @Column(name = "createtime")
    private Date createTime;

    @Column(name = "updatetime")
    private Date updateTime;

    @Column(name = "isdel")
    private Integer isDel;

    @Column(name = "source")
    private Short source;// 0:机构，1:广告系统

    /**
     * @Description : 获取完整访问路径
     * @Author : zhenyujian
     * @Date : 2015年12月4日 下午5:57:37
     *
     * @Return : String
     */
    public String getUrl(String imgServer) {
        String fmt = "%s%s_%s.%s";
        return String.format(fmt, imgServer, this.fid, this.sn, MIMEType.getExtension(this.getMimeType()));
    }
    
    public static String parseSn(String url){
    	url = url.substring(url.lastIndexOf("/")+1,url.length());
        Pattern pattern = Pattern.compile("_([^.]*)");
    	Matcher matcher = pattern.matcher( url );
    	if(matcher.find()){
    		return matcher.group(1);
    	}
    	return null;
    }
    
    public static String parseFid(String url){
    	url = url.substring(url.lastIndexOf("/")+1,url.length());
        Pattern pattern = Pattern.compile("([^_]*)");
    	Matcher matcher = pattern.matcher( url );
    	if(matcher.find()){
    		return matcher.group(1);
    	}
    	return null;
    }
    
    public static Integer parseMimetype(String url){
    	url = url.substring(url.lastIndexOf("/")+1,url.length());
        Pattern pattern = Pattern.compile("\\.(.*)");
    	Matcher matcher = pattern.matcher( url );
    	if(matcher.find()){
    		String extension = matcher.group(1);
    		return MIMEType.getCode(extension);
    		
    	}
    	return null;
    }
    
    public static void main(String args[]){
    	String url = "http://test-img.gsxservice.com/727673_7elqq65c.jpg";
    	System.out.println( parseSn(url) );
    	System.out.println( parseFid(url) );
    	System.out.println( parseMimetype(url) );
    }
}
