
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.po;

import java.util.Date;

import org.apache.commons.lang3.StringUtils;

import lombok.Data;

import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

/**
 * @title OrgInfo
 * @desc yunying.org_info
 * @author shizuwei
 * @date 2015年12月3日
 * @version 1.0
 */
@Entity
@Data
@Table(name = "org_info", catalog = "yunying")
public class OrgInfo {

    @Id
    @GeneratedValue
    private Integer id;

    @Column(name = "org_id")
    private Integer orgId;

    @Column(name = "name")
    private String name;

    @Column(name = "area_id")
    private Long areaId;

    @Column(name = "shortname")
    private String shortName;

    @Column(name = "org_type")
    private Integer orgType;

    @Column(name = "auditstatus")
    private Integer auditStatus;

    @Column(name = "is_valid")
    private Integer isValid;

    // 400分机号码
    @Column(name = "extension")
    private String extension;

    @Column(name = "sign_status")
    private Integer signStatus;

    @Column(name = "contacts")
    private String contacts;

    @Column(name = "id_card_type")
    private Integer idCardType;

    @Column(name = "id_card")
    private String idCard;

    @Column(name = "id_card_storage_id")
    private Integer idCardStorageId;

    @Column(name = "biz_license")
    private String bizLicense;

    @Column(name = "biz_license_storage_id")
    private Integer bizLicenseStorageId;

    @Column(name = "sch_license_type")
    private Integer schLicenseType;

    @Column(name = "sch_license")
    private String schLicense;

    @Column(name = "sch_license_storage_id")
    private Integer schLicenseStorageId;

    @Column(name = "createtime")
    private Date createTime;

    @Column(name = "updatetime")
    private Date updateTime;

    @Column(name = "reject_reason")
    private String rejectReason;

    @Column(name = "reject_reason_other")
    private String rejectReasonOther;

    @Column(name = "first_efficient_time")
    private Date firstEfficientTime;

    @Column(name = "has_display")
    private int hasDisplay;// 是否已显示任务完成窗口

    @Column(name = "marketing_status")
    private int marketingStatus;

    @Column(name = "teacher_signin")
    private int teacherSignin;

    // -----UI 2.0补充字段
    // 纬度
    @Column(name = "latitude")
    private Double latitude;

    // 经度
    @Column(name = "longitude")
    private Double longitude;
    // -----UI 2.0补充字段---END---

    public boolean isPassAudit() {
        if (this.auditStatus.intValue() == AuditStatus.PASS.getValue()) {
            return true;
        }
        return false;
    }

    public String getShowName() {
        if (StringUtils.isNotBlank(this.contacts)) {
            return this.contacts;
        }
        return this.shortName;
    }
}
