
/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.po;

import java.sql.Timestamp;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;


/**
 * 机构主页默认模板配置
 *
 * @author zhangbing
 * @version 1.0
 * @title OrgHomepageTemplate
 * @desc TODO
 * @date 2015年12月3日
 */
@Entity
@Data
@Table(catalog = "yunying", name = "tx_homepage_template")
public class OrgHomepageTemplate {

    //主键
    @Id
    @GeneratedValue
    private Integer id;

    //主页默认模板配置
    @Column(name = "content")
    private String content;

    //默认模板创建时间
    @Column(name = "create_time")
    private Timestamp createTime;

    //更新时间
    @Column(name = "update_time")
    private Timestamp updateTime;

    //模板状态:0=有效,1=无效
    @Column(name = "status")
    private Integer status;

    //是否默认模板:0=默认,1=非默认
    @Column(name = "is_default")
    private Integer isDefault;

    //模板缩略图
    @Column(name = "url")
    private String url;

    //模板名称
    @Column(name = "template_name")
    private String templateName;

    //模板中文名称
    @Column(name = "display_name")
    private String displayName;

    //模板排序
    @Column(name = "display_order")
    private Integer displayOrder;
}

    