/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.bean.impl.LikeExp;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.bean.impl.OrExp;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.beust.jcommander.internal.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;

/**
 * @author caoliang
 * @version 1.0
 * @title TXCascadeCredentialDaoImpl
 * @desc TODO
 * @date 2016年5月10日
 */

@Repository
public class TXCascadeCredentialDaoImpl extends JdbcTemplateDaoSupport<TXCascadeCredential> implements TXCascadeCredentialDao {

    /**
     * @param
     */
    public TXCascadeCredentialDaoImpl() {
        super(TXCascadeCredential.class);
    }

    @Override
    public TXCascadeCredential getByMobile(String mobile) {
        SingleSqlBuilder<TXCascadeCredential> builder = createSqlBuilder();
        builder.eq("mobile", mobile);
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        return uniqueResult(builder);
    }

    @Override
    public List<TXCascadeCredential> getByCredentialIds(Collection<Integer> credentialIds, Integer delStatus) {
        Map<String, Object> param = new HashMap<>();
        param.put("credentialIds", credentialIds);
        String sql = "select * from yunying.tx_cascade_credential where id in (:credentialIds)";
        if (delStatus != null) {
            sql += " and isdel = :normal";
            param.put("normal", delStatus);  //是否删除
        }

        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<List<TXCascadeCredential>>() {

            @Override
            public List<TXCascadeCredential> extractData(ResultSet rs) throws SQLException, DataAccessException {
                List<TXCascadeCredential> txCascadCredentials = new ArrayList<>();
                while (rs.next()) {
                    TXCascadeCredential txCascadCredential = new TXCascadeCredential();
                    txCascadCredential.setId(rs.getInt("id"));
                    txCascadCredential.setAvatar(rs.getString("avatar"));
                    txCascadCredential.setMobile(rs.getString("mobile"));
                    txCascadCredential.setName(rs.getString("name"));
                    txCascadCredentials.add(txCascadCredential);
                }
                return txCascadCredentials;
            }
        });
    }

    @Override
    public List<TXCascadeCredential> getTxCascadCredentialListByCredentialIds(Collection<Integer> credentialIds) {
        Map<String, Object> param = new HashMap<>();
        param.put("credentialIds", credentialIds);
        param.put("normal", DeleteStatus.NORMAL.getValue());  //是否删除
        String sql = "select * from yunying.tx_cascade_credential where id in (:credentialIds) and isdel = :normal order by name desc, mobile desc";

        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<List<TXCascadeCredential>>() {

            @Override
            public List<TXCascadeCredential> extractData(ResultSet rs) throws SQLException, DataAccessException {
                List<TXCascadeCredential> txCascadCredentials = new ArrayList<>();
                while (rs.next()) {
                    TXCascadeCredential txCascadCredential = new TXCascadeCredential();
                    txCascadCredential.setId(rs.getInt("id"));
                    txCascadCredential.setAvatar(rs.getString("avatar"));
                    txCascadCredential.setMobile(rs.getString("mobile"));
                    txCascadCredential.setName(rs.getString("name"));
                    txCascadCredentials.add(txCascadCredential);
                }
                return txCascadCredentials;
            }
        });
    }

    @Override
    public Map<Long, String> getTxCascadCredentialListByCascdeIds(Collection<Integer> cascadeIds) {
        if (cascadeIds.isEmpty()) {
            return Maps.newHashMap();
        }
        Map<String, Object> param = new HashMap<>();
        param.put("cascadeIds", cascadeIds);
        param.put("normal", DeleteStatus.NORMAL.getValue());  //是否删除
        String sql = "select tca.id,tcc.name from yunying.tx_cascade_credential tcc,yunying.tx_cascade_account tca where tcc.id=tca.credential_id and tca.id in (:cascadeIds) and tcc.isdel = :normal";

        final Map<Long, String> txCasCadeMap = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, String>>() {
            @Override
            public Map<Long, String> extractData(ResultSet resultSet) throws SQLException, DataAccessException {
                while (resultSet.next()) {
                    txCasCadeMap.put(resultSet.getLong("id"), resultSet.getString("name"));
                }
                return txCasCadeMap;
            }
        });
        return txCasCadeMap;
    }

    @Override
    public TXCascadeCredential getTXCascadeCredentialByCredentialId(Integer credentialId) {
        SingleSqlBuilder<TXCascadeCredential> builder = createSqlBuilder();
        builder.eq("id", credentialId);
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        return uniqueResult(builder);
    }


    @Override
    public Map<Long, String> getTxCascadCredentialNameByCascdeIds(Collection<Integer> cascadeIds) {
        if (cascadeIds.isEmpty()) {
            return Maps.newHashMap();
        }
        Map<String, Object> param = new HashMap<>();
        param.put("cascadeIds", cascadeIds);
        String sql = "select tca.id,tcc.name from yunying.tx_cascade_credential tcc,yunying.tx_cascade_account tca where tcc.id=tca.credential_id and tca.id in (:cascadeIds)";

        final Map<Long, String> txCasCadeMap = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, String>>() {
            @Override
            public Map<Long, String> extractData(ResultSet resultSet) throws SQLException, DataAccessException {
                while (resultSet.next()) {
                    txCasCadeMap.put(resultSet.getLong("id"), resultSet.getString("name"));
                }
                return txCasCadeMap;
            }
        });
        return txCasCadeMap;
    }

    @Override
    public Map<Integer, TXCascadeCredential> getTxCascadeNameAndAvatar(Collection<Integer> cascadeIds) {
        if (cascadeIds.isEmpty()) {
            return Maps.newHashMap();
        }
        Map<String, Object> param = new HashMap<>();
        param.put("cascadeIds", cascadeIds);
        String sql = "select tca.id,tcc.name,tcc.avatar from yunying.tx_cascade_credential tcc,yunying.tx_cascade_account tca where tcc.id=tca.credential_id and tca.id in (:cascadeIds)";

        final Map<Integer, TXCascadeCredential> txCasCadeMap = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Integer, TXCascadeCredential>>() {
            @Override
            public Map<Integer, TXCascadeCredential> extractData(ResultSet resultSet) throws SQLException, DataAccessException {
                while (resultSet.next()) {
                    TXCascadeCredential credential = new TXCascadeCredential();
                    credential.setAvatar(resultSet.getString("avatar"));
                    credential.setName(resultSet.getString("name"));
                    txCasCadeMap.put(resultSet.getInt("id"), credential);
                }
                return txCasCadeMap;
            }
        });
        return txCasCadeMap;
    }

    @Override
    public List<TXCascadeCredential> gueryByKey(String key, Integer cascadeId, Collection<Integer> cascadeAccountIds, PageDto pageDto) {
        SingleSqlBuilder<TXCascadeCredential> builder = createSqlBuilder();
        if (CollectionUtils.isEmpty(cascadeAccountIds)) {
            return Lists.newArrayList();
        }
        if (cascadeId != null) {
            builder.ne("id", cascadeId);
        }
        builder.in("id", cascadeAccountIds);
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        if (!StringUtils.isBlank(key)) {
            Expression leftCondition = new LikeExp("name", key, MatchMode.ANYWHERE);
            Expression rightCondition = new LikeExp("mobile", key, MatchMode.ANYWHERE);
            Expression condition = new OrExp(leftCondition, rightCondition);
            builder.or(condition);
        }

        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        builder.asc("name", true);
        return queryList(builder);
    }

	@Override
	public Map<Integer, TXCascadeCredential> getCredentialMap(List<Integer> credentialIds) {
		SingleSqlBuilder<TXCascadeCredential> builder = createSqlBuilder();
        builder.in("id", credentialIds);
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        List<TXCascadeCredential> credentials = queryList(builder);
        Map<Integer, TXCascadeCredential> data = Maps.newHashMap();
        if(CollectionUtils.isNotEmpty(credentials)){
        	for(TXCascadeCredential credential : credentials){
        		data.put(credential.getId(), credential);
        	}
        }
        return data;
	}
}
