/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @title TXCampusAccountDaoImpl
 * @desc TODO 
 * @author caoliang
 * @date 2016年5月10日
 * @version 1.0
 */
    
@Repository
public class TXAccountDaoImpl extends JdbcTemplateDaoSupport<TXAccount> implements TXAccountDao {

    /**
     * @param entityClass
     */
    public TXAccountDaoImpl() {
        super(TXAccount.class);
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.dal.org.dao.TXCampusAccountDao#getByOrgId(java.lang.Integer)
     */
        
    @Override
    public TXAccount getByOrgId(Integer orgId) {
        SingleSqlBuilder<TXAccount> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        builder.eq("status", TXAccountStatus.VALID.getCode());
        return uniqueResult(builder);
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.dal.org.dao.TXAccountDao#getByIdAndOrgId(java.lang.Integer, java.lang.Integer)
     */
        
    @Override
    public TXAccount getByIdAndOrgId(Integer id, Integer orgId) {
        SingleSqlBuilder<TXAccount> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("id", id);
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        builder.eq("status", TXAccountStatus.VALID.getCode());
        return uniqueResult(builder);
    }

    @Override
    public TXAccount getByOrgNumber(Integer orgNumber) {
        
        SingleSqlBuilder<TXAccount> builder = createSqlBuilder();
        builder.eq("orgNumber", orgNumber);
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        return uniqueResult(builder);
            
    }

    @Override
    public Map<Long, TXAccount> getAccountTypeMap(Collection<Long> orgIds) {
        SingleSqlBuilder<TXAccount> builder = createSqlBuilder();
        builder.in("orgId", orgIds);
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        builder.eq("status", TXAccountStatus.VALID.getCode());
        List<TXAccount> txAccontList = queryList(builder);
        Map<Long, TXAccount> txAccountMap = new HashMap<>();
        if(txAccontList != null && txAccontList.size() >0){
            for(TXAccount txAccount : txAccontList){
                txAccountMap.put(txAccount.getOrgId().longValue(), txAccount);
            }
        }
        
        return txAccountMap;
    }

}
