package com.baijia.tianxiao.dal.org.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgVideoDao;
import com.baijia.tianxiao.dal.org.po.OrgVideo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

@Repository
public class OrgVideoDaoImpl extends JdbcTemplateDaoSupport<OrgVideo> implements OrgVideoDao {

    public OrgVideoDaoImpl() {
        super(OrgVideo.class);
    }

    @Override
    public List<OrgVideo> searchOrgAllVideo(Integer orgId, Integer isdel, PageDto pageDto, String... queryProps) {
        SingleSqlBuilder<OrgVideo> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        builder.setPage(pageDto);
        return queryList(builder);
    }
    
}
