
/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao.impl;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.dao.OrgTxtMsgDao;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;


/**
 * @author zhangbing
 * @version 1.0
 * @title OrgTxtMsgDaoImpl
 * @desc TODO
 * @date 2015年12月4日
 */
@Repository("tianxiao_dal_yunying_orgTxtMsgDao")
public class OrgTxtMsgDaoImpl extends JdbcTemplateDaoSupport<OrgTxtMsg> implements OrgTxtMsgDao {

    /**
     */
    public OrgTxtMsgDaoImpl() {
        super(OrgTxtMsg.class);
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.dal.org.dao.OrgTxtMsgDao#getOrgTxtById(int)
     */
    @Override
    public OrgTxtMsg getOrgTxtById(int orgId) {
        SingleSqlBuilder<OrgTxtMsg> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        return uniqueResult(builder);
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.dal.org.dao.OrgTxtMsgDao#getOrgTxtByIdAndType(int, int)
     */
    @Override
    public OrgTxtMsg getOrgTxtByIdAndType(int orgId, int type) {
        SingleSqlBuilder<OrgTxtMsg> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("type", type);
        builder.eq("auditstatus", AuditStatus.PASS.getValue());

        builder.desc("createTime");
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(1);
        builder.setPage(pageDto);
        return uniqueResult(builder);
    }


    @Override
    public OrgTxtMsg queryOrgTxtByType(int type, String value) {
        SingleSqlBuilder<OrgTxtMsg> builder = createSqlBuilder();
        builder.eq("value", value);
        builder.eq("type", type);
        builder.eq("auditstatus", AuditStatus.PASS.getValue());

        builder.desc("createTime");
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(1);
        builder.setPage(pageDto);
        return uniqueResult(builder);
    }
}

    