package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.org.dao.OrgTemplateCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgTemplateCourse;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/1/28
 * Time: 下午2:52
 * To change this template use File | Settings | File Templates.
 */
@Repository
public class OrgTemplateCourseDaoImpl extends JdbcTemplateDaoSupport<OrgTemplateCourse> implements OrgTemplateCourseDao {

    public OrgTemplateCourseDaoImpl() {
        super(OrgTemplateCourse.class);
    }

    @Override
    public void delByModule(int orgId, int templateId, List<Integer> modules) {
        StringBuilder sb = new StringBuilder("update yunying.org_template_course set is_del=1 ");
        sb.append("where org_id = :orgId ");
        sb.append("and template_id = :templateId ");
        sb.append("and module_type in (:modules) ");

        Map params = Maps.newHashMap();
        params.put("orgId", orgId);
        params.put("templateId", templateId);
        params.put("modules", modules);

        this.getNamedJdbcTemplate().update(sb.toString(), params);
    }

    @Override
    public List<OrgTemplateCourse> getByModule(int orgId, int templateId, int module) {
        SingleSqlBuilder<OrgTemplateCourse> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("templateId", templateId);
        builder.eq("moduleType", module);
        builder.eq("isDel", DataStatus.NORMAL.getValue());
        builder.asc("displayOrder");

        return queryList(builder);
    }
}
