/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Maps;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @title OrgStorageDaoImpl
 * @desc TODO
 * @author zhangbing
 * @date 2015年12月5日
 * @version 1.0
 */
@Repository("tianxiao_dal_yunying_orgStorageDao")
public class OrgStorageDaoImpl extends JdbcTemplateDaoSupport<OrgStorage> implements OrgStorageDao {

    /**
     * @param entityClass
     */
    public OrgStorageDaoImpl() {
        super(OrgStorage.class);
    }

    @Override
    public void save(OrgStorage orgStorage) {
        super.save(orgStorage);
    }

    @Override
    public OrgStorage getById(int id) {
        return super.getById(id);
    }

    @Override
    public Map<Long, OrgStorage> getOrgStorageMapByIds(Collection<Long> avatarIds) {
        if (avatarIds.isEmpty()) {
            return Collections.emptyMap();
        }

        List<OrgStorage> orgStorages = getByIds(avatarIds);

        if (CollectionUtils.isEmpty(orgStorages)) {
            return Collections.emptyMap();
        }
        Map<Long, OrgStorage> result = Maps.newHashMap();
        for (OrgStorage orgStorage : orgStorages) {
            result.put(orgStorage.getId().longValue(), orgStorage);
        }
        return result;
    }

	@Override
	public List<OrgStorage> list(String fid, String sn, Integer mimeType) {
		if(fid==null && sn==null && mimeType==null){
			return null;
		}
		
		SingleSqlBuilder<OrgStorage> builder = createSqlBuilder();
        if (fid != null) {
        	builder.eq("fid", fid);
        }
        if(sn != null){
        	builder.eq("sn", sn);
        }
        if(mimeType != null){
        	builder.eq("mimeType", mimeType);
        }
        return queryList(builder);
	}

    

}
