
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgPhotoDao;
import com.baijia.tianxiao.dal.org.po.OrgPhoto;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.apache.commons.collections4.map.HashedMap;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @title OrgPhotoDaoImpl
 * @desc TODO
 * @author zhangbing
 * @date 2015年12月5日
 * @version 1.0
 */
@Repository("tianxiao_dal_yunying_orgPhotoDao")
public class OrgPhotoDaoImpl extends JdbcTemplateDaoSupport<OrgPhoto> implements OrgPhotoDao {

    /**
     */
    public OrgPhotoDaoImpl() {
        super(OrgPhoto.class);
    }

    @Override
    public List<OrgPhoto> getByOrgIdAndCategory(int orgId, int category) {
        SingleSqlBuilder<OrgPhoto> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("category", category);
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        builder.eq("auditstatus", AuditStatus.PASS.getValue());
        builder.desc("createTime");
        return queryList(builder);
    }


    public int countOrgIdAndCategory(long orgId, int category) {
        SingleSqlBuilder<OrgPhoto> builder = createSqlBuilder();
        builder.count("id");
        builder.eq("orgId", orgId);
        builder.eq("category", category);
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        builder.eq("auditstatus", AuditStatus.PASS.getValue());
        return queryForObject(builder, Integer.class);
    }

}
