
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.commons.OrgStatisticsExtractor;
import com.baijia.tianxiao.dal.org.dao.OrgGroupMsgDao;
import com.baijia.tianxiao.dal.org.po.OrgGroupMsg;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @title OrgGroupMsgDaoImpl
 * @desc TODO
 * @author bjhl
 * @date 2016年2月24日
 * @version 1.0
 */
@Repository
public class OrgGroupMsgDaoImpl extends JdbcTemplateDaoSupport<OrgGroupMsg> implements OrgGroupMsgDao {

    public OrgGroupMsgDaoImpl() {
        super(OrgGroupMsg.class);
    }

    @Override
    public List<OrgGroupMsg> getByOrgId(Long orgId, PageDto page, String...queryProps) {
        SingleSqlBuilder<OrgGroupMsg> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        builder.setPage(page);
        builder.desc("createTime");
        return queryList(builder);
    }

    @Override
    public Map<Long, Integer> getOrgGroupMsgTotal(Date startDate, Date endDate, List<Long> TianxiaoOrgIds) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", TianxiaoOrgIds);

        String sql = "select count(1) as count,org_id from yunying.org_group_msg where org_id in (:orgIds) ";
        if (startDate != null ) {
            sql += " and create_time between :startDate and :endDate";
            param.put("startDate", startDate);
            param.put("endDate", endDate);
        }
        sql += " GROUP BY org_id";
        return this.getNamedJdbcTemplate().query(sql, param, new OrgStatisticsExtractor());
    }

    @Override
    public Map<Long, List<OrgGroupMsg>> getOrgGroupMsgMap(Date startDate, Date endDate, List<Long> TianxiaoOrgIds) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", TianxiaoOrgIds);

        String sql = "select * from yunying.org_group_msg where org_id in (:orgIds) ";
        if (startDate != null ) {
            sql += " and create_time between :startDate and :endDate";
            param.put("startDate", startDate);
            param.put("endDate", endDate);
        }
        
        return getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, List<OrgGroupMsg>>>() {

            @Override
            public Map<Long, List<OrgGroupMsg>> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Long, List<OrgGroupMsg>> map = new HashMap<>();
                while(rs.next()){
                    Long orgId = rs.getLong("org_id");
                    List<OrgGroupMsg> list = map.get(orgId);
                    OrgGroupMsg orgGroupMsg = new OrgGroupMsg();
                    orgGroupMsg.setId(rs.getLong("id"));
                    orgGroupMsg.setOrgId(rs.getLong("org_id"));
                    orgGroupMsg.setSubject(rs.getString("subject"));
                    orgGroupMsg.setCreateTime(rs.getDate("create_time"));
                    if(list == null){
                        list = new ArrayList<>();
                        map.put(orgId, list);
                    }
                    list.add(orgGroupMsg);
                }
                return map;
            }
        });
    }

}
