/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import java.util.List;
import java.util.Set;

import com.baijia.tianxiao.consants.DataStatus;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.org.dao.OrgBranchsDao;
import com.baijia.tianxiao.dal.org.po.OrgBranchs;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;

/**
 * @author : zhenyujian
 * @title : OrgBranchsDaoImpl
 * @description :
 * @date : 2015年12月5日 下午3:56:36
 */
@Repository("tianxiao_dal_yunying_orgBranchsDao")
public class OrgBranchsDaoImpl extends JdbcTemplateDaoSupport<OrgBranchs> implements OrgBranchsDao {

    public OrgBranchsDaoImpl() {
        super(OrgBranchs.class);
    }

    @Override
    public Integer countAllBranchs() {
        SingleSqlBuilder<OrgBranchs> builder = createSqlBuilder();
        builder.count("id");
        return queryForObject(builder, Integer.class);
    }

    @Override
    public List<OrgBranchs> listAllBranchs(int currPageCount, int pageSize) {
        SingleSqlBuilder<OrgBranchs> sqlBuilder = createSqlBuilder();
        PageDto pageDto = new PageDto();
        pageDto.setCurPageCount(currPageCount);
        pageDto.setPageSize(pageSize);
        sqlBuilder.setPage(pageDto);
        return this.queryList(sqlBuilder);
    }

    @Override
    public List<OrgBranchs> listBranchsByOrgId(int orgId) {
        SingleSqlBuilder<OrgBranchs> sqlBuilder = createSqlBuilder();
        sqlBuilder.eq("orgId", orgId);
        sqlBuilder.eq("isdel", DataStatus.NORMAL.getValue());
        return this.queryList(sqlBuilder);
    }

    @Override
    public List<OrgBranchs> listBranchsByOrgIds(Set<Integer> orgIds) {
        if (GenericsUtils.isNullOrEmpty(orgIds)) {
            return GenericsUtils.emptyList();
        }
        SingleSqlBuilder<OrgBranchs> sqlBuilder = createSqlBuilder();
        sqlBuilder.in("orgId", orgIds);
        sqlBuilder.eq("isdel", DataStatus.NORMAL.getValue());
        sqlBuilder.setOrder(Order.desc("update_time"));
        return this.queryList(sqlBuilder);
    }

}
