/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @title OrgAccountDaoImpl
 * @desc TODO
 * @author zhangbing
 * @date 2015年12月2日
 * @version 1.0
 */
@Repository("orgAccountDao")
public class OrgAccountDaoImpl extends JdbcTemplateDaoSupport<OrgAccount> implements OrgAccountDao {

    /**
     * @param entityClass
     */
    public OrgAccountDaoImpl() {
        super(OrgAccount.class);
    }

    @Override
    public OrgAccount getAccountByNumber(Integer number, String...queryProps) {
        SingleSqlBuilder<OrgAccount> builder = createSqlBuilder(queryProps);
        builder.eq("number", number);
        return uniqueResult(builder);
    }

    @Override
    public OrgAccount getAccountById(int id, String...queryProps) {
        SingleSqlBuilder<OrgAccount> builder = createSqlBuilder(queryProps);
        builder.eq("id", id);
        return uniqueResult(builder);
    }

    @Override
    public List<OrgAccount> getAccountByNumbers(Collection<Integer> numbers, final String...queryProps) {
        if (CollectionUtils.isEmpty(numbers)) {
            return Collections.emptyList();
        }
        return new ListBatchQueryTemplate<Integer, OrgAccount>().batchQuery(numbers,
                new BatchQueryCallback<Integer, List<OrgAccount>>() {
                    @Override
                    public List<OrgAccount> doQuery(Collection<Integer> querySet) {
                        SingleSqlBuilder<OrgAccount> builder = createSqlBuilder(queryProps);
                        builder.in("number", querySet);
                        return queryList(builder);
                    }
                });
    }

    @Override
    public OrgAccount getAccountByMobile(String mobile) {
        SingleSqlBuilder<OrgAccount> builder = createSqlBuilder();
        builder.eq("mobile", mobile);
        return uniqueResult(builder);
    }

    @Override
    public Map<Long, Long> getOrgIdsByOrgNumbers(List<Long> orgNumbers) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgNumbers", orgNumbers);
        String sql = "select id, number from yunying.org_account where number in (:orgNumbers)";
        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, Long>>() {

            @Override
            public Map<Long, Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Long, Long> map = new HashMap<>();
                while (rs.next()) {
                    Long orgNumber = rs.getLong("number");
                    Long orgId = rs.getLong("id");
                    map.put(orgNumber, orgId);
                }
                return map;
            }
        });
    }

    @Override
    public Map<Long, Integer> getorgNumbersByOrgIds(Collection<Long> orgIds) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", orgIds);
        String sql = "select id, number from yunying.org_account where id in (:orgIds)";
        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, Integer>>() {

            @Override
            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Long, Integer> map = new HashMap<>();
                while (rs.next()) {
                    Integer orgNumber = rs.getInt("number");
                    Long orgId = rs.getLong("id");
                    map.put(orgId, orgNumber);
                }
                return map;
            }
        });
    }

    @Override
    public List<OrgAccount> getOrgAccountByOrgIds(Collection<Integer> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.emptyList();
        }
        return new ListBatchQueryTemplate<Integer, OrgAccount>().batchQuery(orgIds,
                new BatchQueryCallback<Integer, List<OrgAccount>>() {
                    @Override
                    public List<OrgAccount> doQuery(Collection<Integer> querySet) {
                        SingleSqlBuilder<OrgAccount> builder = createSqlBuilder();
                        builder.in("id", querySet);
                        return queryList(builder);
                    }
                });
    }

    @Override
    public Map<Integer, Long> batchSearchOrgIds(List<Integer> orgNumbers) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgNumbers", orgNumbers);
        String sql = "select id, number from yunying.org_account where number in (:orgNumbers)";
        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Integer, Long>>() {

            @Override
            public Map<Integer, Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Integer, Long> map = new HashMap<>();
                while (rs.next()) {
                    Integer orgNumber = rs.getInt("number");
                    Long orgId = rs.getLong("id");
                    map.put(orgNumber, orgId);
                }
                return map;
            }
        });
    }

}