/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao;

import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.List;

/**
 * @author caoliang
 * @version 1.0
 * @title TXCascadeAccountDao
 * @desc TODO
 * @date 2016年5月10日
 */
public interface TXCascadeAccountDao extends CommonDao<TXCascadeAccount> {
    Integer getCountByOrgId(Integer orgId);

    TXCascadeAccount getByIdAndOrgId(Integer id, Integer orgId);

    List<TXCascadeAccount> getByOrgIds(List<Integer> orgIds, PageDto pageDto);

    Integer getCountByOrgIds(List<Integer> orgIds);

    Integer getCountByOrgIds(List<Integer> orgIds, Integer status);

    List<TXCascadeAccount> getByCIdAndOrgId(Integer orgId, Integer credentialId);

    List<TXCascadeAccount> getTXCascadeAccountListByOrgId(Long orgId);

    List<Integer> listIdByAccountType(Integer orgId, Integer accountType);

    TXCascadeAccount getByCredentialIdAndOrgId(Integer orgId, Integer credentialId);

    List<TXCascadeAccount> getTXCascadeAccountListByOrgId(Long orgId, Integer status);

    List<TXCascadeAccount> getTXCascadeAccountListByStatusAndOrgId(Integer cascadeId, int status, Integer orgId);

    List<TXCascadeAccount> getTXCascadeAccountListByOrgIds(Collection<Integer> orgIds);

    List<TXCascadeAccount> getByCredentialId(Integer credentialId);

    List<TXCascadeAccount> getValidAccountsByCredentialId(Integer credentialId);

    /**
     * 查询指定机构中所有的用户
     *
     * @param orgId：机构id
     * @param cascadeId：过滤掉的班主任id
     * @return
     */
    List<TXCascadeAccount> listIdByOrgId(Long orgId, Integer cascadeId);

    List<TXCascadeAccount> getAllByPageDto(PageDto pageDto);

    void incrVersionByOrgId(int orgId);

    void incrVersionByCredentialId(int credentialId);

    void deleteById(int cascadeId);

    void deleteByOrgId(int orgId);
}
