/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao;

import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.List;

/**
 * @author caoliang
 * @version 1.0
 * @title TXCampusAccountDao
 * @desc TODO
 * @date 2016年5月10日
 */

public interface OrgSubAccountDao extends CommonDao<OrgSubAccount> {

    OrgSubAccount getMasterByOrgId(Integer orgId);

    List<OrgSubAccount> getSlavesByMasterOrgId(Integer orgId, PageDto pageDto);

    Integer getSlavesCountByMasterOrgId(Integer orgId);

    OrgSubAccount getByOrgId(Integer orgId);

    OrgSubAccount getByOrgIdIgnoreDelStatus(Integer orgId);

    OrgSubAccount getSlaveIgnoreStatus(Integer orgId, Integer masterId);

    List<OrgSubAccount> getSlavesIgnoreStatus(Integer orgId, PageDto pageDto);

    /**
     * 根据orgIds获取有主分校区的机构
     * param: status 主分校区是否解除关联
     */
    List<OrgSubAccount> getOrgSubAccountByOrgIds(Collection<Long> orgIds, Integer status);

    List<OrgSubAccount> getAllByPageDto(PageDto pageDto);

    public void incrVersionByOrgId(int orgId);

	public OrgSubAccount getByOrgIdIgnoreIsdel(Integer orgId);

    void deleteByOrgid(int orgId);

    /**
     * @param orgId
     */
    void resetOrgWechatType(Integer orgId);

    List<OrgSubAccount> getMasterAndSlaves(Integer orgId, PageDto pageDto);
}
