
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.constant;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @title TXAccountType
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年5月13日
 * @version 1.0
 */

public enum TXAccountType {
    ERROR_TYPE(0, "版本错误，尽快查证并更改"), 
    ZHUANYE(1, "专业版"), 
    QIYE(2, "企业版"), 
    QIJIAN(3, "旗舰版"), 
    DINGZHI(4, "定制版"), 
    DAZHONG(5, "大众版"), 
    BAIJIN(6, "白金版"),;

    private Integer code;
    private String label;

    TXAccountType(Integer code, String label) {
        this.code = code;
        this.label = label;
    }

    private static final Map<Integer, TXAccountType> map = new HashMap<>();
    
    //付费版本map
    private static final Set<TXAccountType> PAYSET = new HashSet<>();

    static {
        for (TXAccountType txAccountTypeEnum : TXAccountType.values()) {
            map.put(txAccountTypeEnum.getCode(), txAccountTypeEnum);
        }
        
        PAYSET.add(ZHUANYE);
        PAYSET.add(QIYE);
        PAYSET.add(BAIJIN);
        PAYSET.add(DINGZHI);
        PAYSET.add(QIJIAN);
    }
    
    public static Set<TXAccountType> getPaySet(){
        return Collections.unmodifiableSet(PAYSET);
    }

    public static TXAccountType getTXAccountTypeByCode(Integer code) {
        TXAccountType txAccountTypeEnum = map.get(code);
        return txAccountTypeEnum;
    }
    
    public Integer getCode() {

        return code;
    }

    public void setCode(Integer code) {

        this.code = code;
    }

    public String getLabel() {

        return label;
    }

    public void setLabel(String label) {

        this.label = label;
    }

}
