/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.constant;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * @title StudentType
 * @desc TODO
 * @author shanyu
 * @date 2015年12月5日
 * @version 1.0
 */

public enum StudentType {
    CONSULT_USER(0, "咨询本学员"), ORG_STUDENTS(1, "机构正式学员"), ;

    private int code;

    private String message;

    private StudentType(int code, String message) {
        this.code = code;
        this.message = message;
    }

    private final static Map<Integer, StudentType> map = Maps.newHashMap();

    static {
        for (StudentType studentType : StudentType.values()) {
            map.put(studentType.code, studentType);
        }
    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

}
