
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.constant;

/**
 * @title CampusAccountType
 * @desc O(∩_∩)O~ 
 * @author caoliang
 * @date 2016年5月16日
 * @version 1.0
 */

public enum CampusAccountType {
    MASTER_PRINCIPAL(1, "总校校长"), SLAVE_PRINCIPAL(2, "分校校长"), DIRECTOR(3, "主管"), STAFF(4, "员工");

    private Integer code;
    private String label;
    private Integer level;

    CampusAccountType(Integer code, String label) {
        this.code = code;
        this.label = label;
    }

    public Integer getCode() {

        return code;
    }

    public void setCode(Integer code) {

        this.code = code;
    }

    public String getLabel() {

        return label;
    }

    public void setLabel(String label) {

        this.label = label;
    }

    public static String getLabelByCode(int code) {
        for (CampusAccountType ct : CampusAccountType.values()) {
            if (ct.getCode() == code) {
                return ct.getLabel();
            }
        }
        return null;
    }

    public static boolean isTypeValid(Integer code) {
        if (code == null) {
            return false;
        }
        for(CampusAccountType cType : CampusAccountType.values()){
            if(cType.getCode().intValue() == code){
                return true;
            }
        }
        return false;
    }
    
    public static CampusAccountType getTypeByCode(int code){
        for(CampusAccountType type : CampusAccountType.values()){
            if(type.getCode() == code){
                return type;
            }
        }
        return null;
    }
}
