
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.msg.dao.impl;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.msg.dao.TxSmsCountDao;
import com.baijia.tianxiao.dal.msg.po.TxSmsCount;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.base.Preconditions;

/**
 * @title TxSmsCountDaoImpl
 * @desc TODO
 * @author cxm
 * @date 2016年3月21日
 * @version 1.0
 */
@Repository
public class TxSmsCountDaoImpl extends JdbcTemplateDaoSupport<TxSmsCount> implements TxSmsCountDao {

    @Override
    public TxSmsCount buySmsCount(Long orgId, int count) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Preconditions.checkArgument(count > 0, "buy count must great than 0");

        SingleSqlBuilder<TxSmsCount> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        TxSmsCount smsCount = uniqueResult(builder, true);
        smsCount.setLeftBuyCount(smsCount.getLeftBuyCount() + count);
        this.update(smsCount);
        return smsCount;
    }

    @Override
    public TxSmsCount decreaseSmsCount(Long orgId) {
        return decreaseSmsCount(orgId, 1);
    }

    @Override
    public TxSmsCount decreaseSmsCount(Long orgId, int count) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Preconditions.checkArgument(count > 0, "buy count must great than 0");
        SingleSqlBuilder<TxSmsCount> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        TxSmsCount smsCount = uniqueResult(builder, true);
        smsCount.decreaseMsgCount(count);
        this.update(smsCount);
        return smsCount;
    }

}
