
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.msg.dao;

import com.baijia.tianxiao.dal.msg.po.TxSmsCount;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/**
 * @title TxSmsCountDao
 * @desc TODO
 * @author cxm
 * @date 2016年3月21日
 * @version 1.0
 */
public interface TxSmsCountDao extends CommonDao<TxSmsCount> {

    /**
     * 购买短信条数
     * 
     * @param orgId
     * @param count
     */
    TxSmsCount buySmsCount(Long orgId, int count);

    /**
     * 对短信的可用条数-1,如果-1以后>=0,返回true,否则返回false
     * 
     * @param orgId
     * @return
     */
    TxSmsCount decreaseSmsCount(Long orgId);

    /**
     * 批量发送时候使用,不推荐
     * 
     * @param orgId
     * @param count
     * @return
     */
    TxSmsCount decreaseSmsCount(Long orgId, int count);

}
