package com.baijia.tianxiao.dal.index.dao.impl;

import com.baijia.tianxiao.dal.index.constant.TxVisitorStatus;
import com.baijia.tianxiao.dal.index.dao.TxVisitorDao;
import com.baijia.tianxiao.dal.index.po.TxVisitor;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA. User: Victor Weng Date: 16/3/7 Time: 下午3:21 To change this template use File | Settings |
 * File Templates.
 */
@Repository
@Slf4j
public class TxVisitorDaoImpl extends JdbcTemplateDaoSupport<TxVisitor> implements TxVisitorDao {

    public TxVisitorDaoImpl() {
        super(TxVisitor.class);
    }

    @Override
    public List<TxVisitor> listByTime(Date startDay, Date endDate) {

        SingleSqlBuilder<TxVisitor> builder = createSqlBuilder();
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        builder.eq("applyType", 0);//体验版
        builder.ge("updateTime", startDay);
        builder.le("updateTime", endDate);
        return queryList(builder);
    }

    @Override
    public List<TxVisitor> listBeforeTime(Date thisDate) {
        SingleSqlBuilder<TxVisitor> builder = createSqlBuilder();
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        builder.eq("applyType", 0);//体验版
        builder.le("updateTime", thisDate);
        builder.eq("sendMail", 0);
        log.debug("TxVisitorDaoImpl ==={}",builder.toSql(),builder.collectConditionValue());
        return queryList(builder);
    }

    @Override
    public Integer getActiveCount() {
        SingleSqlBuilder<TxVisitor> builder = createSqlBuilder();
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        builder.eq("status", TxVisitorStatus.ACTIVE.getCode());
        builder.count("id");
        return queryForObject(builder, Integer.class);
    }

    @Override
    public List<TxVisitor> getByMobile(String mobile) {
        SingleSqlBuilder<TxVisitor> builder = createSqlBuilder();
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        // builder.eq("status", TxVisitorStatus.ACTIVE.getCode());
        builder.eq("mobile", mobile);
        return queryList(builder);
    }

    @Override
    public void updateByMobile(TxVisitor tx) {
        String sql =
                "update yunying.tx_visitor set org_name=?,name=?,province=?,city=?,province_id=?,city_id=?,remark=?,apply_type=?,source=?,status=?,create_time=?,update_time=?,isdel=? where mobile=?";
        this.getNamedJdbcTemplate().getJdbcOperations().update(sql,
                new Object[]{tx.getOrgName(), tx.getName(), tx.getProvince(), tx.getCity(), tx.getProvinceId(),
                        tx.getCityId(), tx.getRemark(), tx.getApplyType(), tx.getSource(), tx.getStatus(), tx.getCreateTime(),
                        tx.getUpdateTime(), tx.getIsdel(), tx.getMobile()});
    }

    @Override
    public void modifyPassword(String mobile, String encryptPwd) {
        String sql = "update yunying.tx_visitor set password=:password where mobile=:mobile";
        Map<String, String> params = Maps.newHashMap();
        params.put("mobile", mobile);
        params.put("password", encryptPwd);
        this.getNamedJdbcTemplate().update(sql, params);
    }


    @Override
    public void changeSendMail(Collection<Integer> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        Map<String, Object> params = Maps.newHashMap();
        params.put("ids", ids);
        String sql = "update yunying.tx_visitor set send_mail = 1 where id in (:ids)";
        this.getNamedJdbcTemplate().update(sql, params);
    }
}
